package io.fabric8.knative.internal.pkg.apis.duck.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class SourceStatusBuilder extends SourceStatusFluent<SourceStatusBuilder> implements VisitableBuilder<SourceStatus,SourceStatusBuilder>{
  public SourceStatusBuilder() {
    this(new SourceStatus());
  }
  
  public SourceStatusBuilder(SourceStatusFluent<?> fluent) {
    this(fluent, new SourceStatus());
  }
  
  public SourceStatusBuilder(SourceStatusFluent<?> fluent,SourceStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public SourceStatusBuilder(SourceStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  SourceStatusFluent<?> fluent;
  
  public SourceStatus build() {
    SourceStatus buildable = new SourceStatus(fluent.getAnnotations(),fluent.buildConditions(),fluent.getObservedGeneration(),fluent.getSinkUri());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}