package io.fabric8.knative.messaging.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class InMemoryChannelListBuilder extends InMemoryChannelListFluent<InMemoryChannelListBuilder> implements VisitableBuilder<InMemoryChannelList,InMemoryChannelListBuilder>{
  public InMemoryChannelListBuilder() {
    this(new InMemoryChannelList());
  }
  
  public InMemoryChannelListBuilder(InMemoryChannelListFluent<?> fluent) {
    this(fluent, new InMemoryChannelList());
  }
  
  public InMemoryChannelListBuilder(InMemoryChannelListFluent<?> fluent,InMemoryChannelList instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public InMemoryChannelListBuilder(InMemoryChannelList instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  InMemoryChannelListFluent<?> fluent;
  
  public InMemoryChannelList build() {
    InMemoryChannelList buildable = new InMemoryChannelList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}