package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class RouteSpecFluent<A extends RouteSpecFluent<A>> extends BaseFluent<A>{
  public RouteSpecFluent() {
  }
  
  public RouteSpecFluent(RouteSpec instance) {
    this.copyInstance(instance);
  }
  private ArrayList<TrafficTargetBuilder> traffic = new ArrayList<TrafficTargetBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(RouteSpec instance) {
    instance = (instance != null ? instance : new RouteSpec());
    if (instance != null) {
          this.withTraffic(instance.getTraffic());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToTraffic(int index,TrafficTarget item) {
    if (this.traffic == null) {this.traffic = new ArrayList<TrafficTargetBuilder>();}
    TrafficTargetBuilder builder = new TrafficTargetBuilder(item);
    if (index < 0 || index >= traffic.size()) { _visitables.get("traffic").add(builder); traffic.add(builder); } else { _visitables.get("traffic").add(index, builder); traffic.add(index, builder);}
    return (A)this;
  }
  
  public A setToTraffic(int index,TrafficTarget item) {
    if (this.traffic == null) {this.traffic = new ArrayList<TrafficTargetBuilder>();}
    TrafficTargetBuilder builder = new TrafficTargetBuilder(item);
    if (index < 0 || index >= traffic.size()) { _visitables.get("traffic").add(builder); traffic.add(builder); } else { _visitables.get("traffic").set(index, builder); traffic.set(index, builder);}
    return (A)this;
  }
  
  public A addToTraffic(io.fabric8.knative.serving.v1.TrafficTarget... items) {
    if (this.traffic == null) {this.traffic = new ArrayList<TrafficTargetBuilder>();}
    for (TrafficTarget item : items) {TrafficTargetBuilder builder = new TrafficTargetBuilder(item);_visitables.get("traffic").add(builder);this.traffic.add(builder);} return (A)this;
  }
  
  public A addAllToTraffic(Collection<TrafficTarget> items) {
    if (this.traffic == null) {this.traffic = new ArrayList<TrafficTargetBuilder>();}
    for (TrafficTarget item : items) {TrafficTargetBuilder builder = new TrafficTargetBuilder(item);_visitables.get("traffic").add(builder);this.traffic.add(builder);} return (A)this;
  }
  
  public A removeFromTraffic(io.fabric8.knative.serving.v1.TrafficTarget... items) {
    if (this.traffic == null) return (A)this;
    for (TrafficTarget item : items) {TrafficTargetBuilder builder = new TrafficTargetBuilder(item);_visitables.get("traffic").remove(builder); this.traffic.remove(builder);} return (A)this;
  }
  
  public A removeAllFromTraffic(Collection<TrafficTarget> items) {
    if (this.traffic == null) return (A)this;
    for (TrafficTarget item : items) {TrafficTargetBuilder builder = new TrafficTargetBuilder(item);_visitables.get("traffic").remove(builder); this.traffic.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromTraffic(Predicate<TrafficTargetBuilder> predicate) {
    if (traffic == null) return (A) this;
    final Iterator<TrafficTargetBuilder> each = traffic.iterator();
    final List visitables = _visitables.get("traffic");
    while (each.hasNext()) {
      TrafficTargetBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<TrafficTarget> buildTraffic() {
    return this.traffic != null ? build(traffic) : null;
  }
  
  public TrafficTarget buildTraffic(int index) {
    return this.traffic.get(index).build();
  }
  
  public TrafficTarget buildFirstTraffic() {
    return this.traffic.get(0).build();
  }
  
  public TrafficTarget buildLastTraffic() {
    return this.traffic.get(traffic.size() - 1).build();
  }
  
  public TrafficTarget buildMatchingTraffic(Predicate<TrafficTargetBuilder> predicate) {
      for (TrafficTargetBuilder item : traffic) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingTraffic(Predicate<TrafficTargetBuilder> predicate) {
      for (TrafficTargetBuilder item : traffic) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withTraffic(List<TrafficTarget> traffic) {
    if (this.traffic != null) {
      this._visitables.get("traffic").clear();
    }
    if (traffic != null) {
        this.traffic = new ArrayList();
        for (TrafficTarget item : traffic) {
          this.addToTraffic(item);
        }
    } else {
      this.traffic = null;
    }
    return (A) this;
  }
  
  public A withTraffic(io.fabric8.knative.serving.v1.TrafficTarget... traffic) {
    if (this.traffic != null) {
        this.traffic.clear();
        _visitables.remove("traffic");
    }
    if (traffic != null) {
      for (TrafficTarget item : traffic) {
        this.addToTraffic(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasTraffic() {
    return this.traffic != null && !this.traffic.isEmpty();
  }
  
  public TrafficNested<A> addNewTraffic() {
    return new TrafficNested(-1, null);
  }
  
  public TrafficNested<A> addNewTrafficLike(TrafficTarget item) {
    return new TrafficNested(-1, item);
  }
  
  public TrafficNested<A> setNewTrafficLike(int index,TrafficTarget item) {
    return new TrafficNested(index, item);
  }
  
  public TrafficNested<A> editTraffic(int index) {
    if (traffic.size() <= index) throw new RuntimeException("Can't edit traffic. Index exceeds size.");
    return setNewTrafficLike(index, buildTraffic(index));
  }
  
  public TrafficNested<A> editFirstTraffic() {
    if (traffic.size() == 0) throw new RuntimeException("Can't edit first traffic. The list is empty.");
    return setNewTrafficLike(0, buildTraffic(0));
  }
  
  public TrafficNested<A> editLastTraffic() {
    int index = traffic.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last traffic. The list is empty.");
    return setNewTrafficLike(index, buildTraffic(index));
  }
  
  public TrafficNested<A> editMatchingTraffic(Predicate<TrafficTargetBuilder> predicate) {
    int index = -1;
    for (int i=0;i<traffic.size();i++) { 
    if (predicate.test(traffic.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching traffic. No match found.");
    return setNewTrafficLike(index, buildTraffic(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RouteSpecFluent that = (RouteSpecFluent) o;
    if (!java.util.Objects.equals(traffic, that.traffic)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(traffic,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (traffic != null && !traffic.isEmpty()) { sb.append("traffic:"); sb.append(traffic + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class TrafficNested<N> extends TrafficTargetFluent<TrafficNested<N>> implements Nested<N>{
    TrafficNested(int index,TrafficTarget item) {
      this.index = index;
      this.builder = new TrafficTargetBuilder(this, item);
    }
    TrafficTargetBuilder builder;
    int index;
    
    public N and() {
      return (N) RouteSpecFluent.this.setToTraffic(index,builder.build());
    }
    
    public N endTraffic() {
      return and();
    }
    
  
  }

}