package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaBindingBuilder extends KafkaBindingFluent<KafkaBindingBuilder> implements VisitableBuilder<KafkaBinding,KafkaBindingBuilder>{
  public KafkaBindingBuilder() {
    this(new KafkaBinding());
  }
  
  public KafkaBindingBuilder(KafkaBindingFluent<?> fluent) {
    this(fluent, new KafkaBinding());
  }
  
  public KafkaBindingBuilder(KafkaBindingFluent<?> fluent,KafkaBinding instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaBindingBuilder(KafkaBinding instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaBindingFluent<?> fluent;
  
  public KafkaBinding build() {
    KafkaBinding buildable = new KafkaBinding(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}