package io.fabric8.knative.eventing.v1;

import io.fabric8.knative.internal.pkg.apis.duck.v1.Destination;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpecFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpec;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpecBuilder;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class TriggerSpecFluent<A extends TriggerSpecFluent<A>> extends BaseFluent<A>{
  public TriggerSpecFluent() {
  }
  
  public TriggerSpecFluent(TriggerSpec instance) {
    this.copyInstance(instance);
  }
  private String broker;
  private DeliverySpecBuilder delivery;
  private TriggerFilterBuilder filter;
  private ArrayList<SubscriptionsAPIFilterBuilder> filters = new ArrayList<SubscriptionsAPIFilterBuilder>();
  private DestinationBuilder subscriber;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(TriggerSpec instance) {
    instance = (instance != null ? instance : new TriggerSpec());
    if (instance != null) {
          this.withBroker(instance.getBroker());
          this.withDelivery(instance.getDelivery());
          this.withFilter(instance.getFilter());
          this.withFilters(instance.getFilters());
          this.withSubscriber(instance.getSubscriber());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getBroker() {
    return this.broker;
  }
  
  public A withBroker(String broker) {
    this.broker = broker;
    return (A) this;
  }
  
  public boolean hasBroker() {
    return this.broker != null;
  }
  
  public DeliverySpec buildDelivery() {
    return this.delivery != null ? this.delivery.build() : null;
  }
  
  public A withDelivery(DeliverySpec delivery) {
    this._visitables.remove("delivery");
    if (delivery != null) {
        this.delivery = new DeliverySpecBuilder(delivery);
        this._visitables.get("delivery").add(this.delivery);
    } else {
        this.delivery = null;
        this._visitables.get("delivery").remove(this.delivery);
    }
    return (A) this;
  }
  
  public boolean hasDelivery() {
    return this.delivery != null;
  }
  
  public DeliveryNested<A> withNewDelivery() {
    return new DeliveryNested(null);
  }
  
  public DeliveryNested<A> withNewDeliveryLike(DeliverySpec item) {
    return new DeliveryNested(item);
  }
  
  public DeliveryNested<A> editDelivery() {
    return withNewDeliveryLike(java.util.Optional.ofNullable(buildDelivery()).orElse(null));
  }
  
  public DeliveryNested<A> editOrNewDelivery() {
    return withNewDeliveryLike(java.util.Optional.ofNullable(buildDelivery()).orElse(new DeliverySpecBuilder().build()));
  }
  
  public DeliveryNested<A> editOrNewDeliveryLike(DeliverySpec item) {
    return withNewDeliveryLike(java.util.Optional.ofNullable(buildDelivery()).orElse(item));
  }
  
  public TriggerFilter buildFilter() {
    return this.filter != null ? this.filter.build() : null;
  }
  
  public A withFilter(TriggerFilter filter) {
    this._visitables.remove("filter");
    if (filter != null) {
        this.filter = new TriggerFilterBuilder(filter);
        this._visitables.get("filter").add(this.filter);
    } else {
        this.filter = null;
        this._visitables.get("filter").remove(this.filter);
    }
    return (A) this;
  }
  
  public boolean hasFilter() {
    return this.filter != null;
  }
  
  public FilterNested<A> withNewFilter() {
    return new FilterNested(null);
  }
  
  public FilterNested<A> withNewFilterLike(TriggerFilter item) {
    return new FilterNested(item);
  }
  
  public FilterNested<A> editFilter() {
    return withNewFilterLike(java.util.Optional.ofNullable(buildFilter()).orElse(null));
  }
  
  public FilterNested<A> editOrNewFilter() {
    return withNewFilterLike(java.util.Optional.ofNullable(buildFilter()).orElse(new TriggerFilterBuilder().build()));
  }
  
  public FilterNested<A> editOrNewFilterLike(TriggerFilter item) {
    return withNewFilterLike(java.util.Optional.ofNullable(buildFilter()).orElse(item));
  }
  
  public A addToFilters(int index,SubscriptionsAPIFilter item) {
    if (this.filters == null) {this.filters = new ArrayList<SubscriptionsAPIFilterBuilder>();}
    SubscriptionsAPIFilterBuilder builder = new SubscriptionsAPIFilterBuilder(item);
    if (index < 0 || index >= filters.size()) { _visitables.get("filters").add(builder); filters.add(builder); } else { _visitables.get("filters").add(index, builder); filters.add(index, builder);}
    return (A)this;
  }
  
  public A setToFilters(int index,SubscriptionsAPIFilter item) {
    if (this.filters == null) {this.filters = new ArrayList<SubscriptionsAPIFilterBuilder>();}
    SubscriptionsAPIFilterBuilder builder = new SubscriptionsAPIFilterBuilder(item);
    if (index < 0 || index >= filters.size()) { _visitables.get("filters").add(builder); filters.add(builder); } else { _visitables.get("filters").set(index, builder); filters.set(index, builder);}
    return (A)this;
  }
  
  public A addToFilters(io.fabric8.knative.eventing.v1.SubscriptionsAPIFilter... items) {
    if (this.filters == null) {this.filters = new ArrayList<SubscriptionsAPIFilterBuilder>();}
    for (SubscriptionsAPIFilter item : items) {SubscriptionsAPIFilterBuilder builder = new SubscriptionsAPIFilterBuilder(item);_visitables.get("filters").add(builder);this.filters.add(builder);} return (A)this;
  }
  
  public A addAllToFilters(Collection<SubscriptionsAPIFilter> items) {
    if (this.filters == null) {this.filters = new ArrayList<SubscriptionsAPIFilterBuilder>();}
    for (SubscriptionsAPIFilter item : items) {SubscriptionsAPIFilterBuilder builder = new SubscriptionsAPIFilterBuilder(item);_visitables.get("filters").add(builder);this.filters.add(builder);} return (A)this;
  }
  
  public A removeFromFilters(io.fabric8.knative.eventing.v1.SubscriptionsAPIFilter... items) {
    if (this.filters == null) return (A)this;
    for (SubscriptionsAPIFilter item : items) {SubscriptionsAPIFilterBuilder builder = new SubscriptionsAPIFilterBuilder(item);_visitables.get("filters").remove(builder); this.filters.remove(builder);} return (A)this;
  }
  
  public A removeAllFromFilters(Collection<SubscriptionsAPIFilter> items) {
    if (this.filters == null) return (A)this;
    for (SubscriptionsAPIFilter item : items) {SubscriptionsAPIFilterBuilder builder = new SubscriptionsAPIFilterBuilder(item);_visitables.get("filters").remove(builder); this.filters.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromFilters(Predicate<SubscriptionsAPIFilterBuilder> predicate) {
    if (filters == null) return (A) this;
    final Iterator<SubscriptionsAPIFilterBuilder> each = filters.iterator();
    final List visitables = _visitables.get("filters");
    while (each.hasNext()) {
      SubscriptionsAPIFilterBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<SubscriptionsAPIFilter> buildFilters() {
    return this.filters != null ? build(filters) : null;
  }
  
  public SubscriptionsAPIFilter buildFilter(int index) {
    return this.filters.get(index).build();
  }
  
  public SubscriptionsAPIFilter buildFirstFilter() {
    return this.filters.get(0).build();
  }
  
  public SubscriptionsAPIFilter buildLastFilter() {
    return this.filters.get(filters.size() - 1).build();
  }
  
  public SubscriptionsAPIFilter buildMatchingFilter(Predicate<SubscriptionsAPIFilterBuilder> predicate) {
      for (SubscriptionsAPIFilterBuilder item : filters) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingFilter(Predicate<SubscriptionsAPIFilterBuilder> predicate) {
      for (SubscriptionsAPIFilterBuilder item : filters) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withFilters(List<SubscriptionsAPIFilter> filters) {
    if (this.filters != null) {
      this._visitables.get("filters").clear();
    }
    if (filters != null) {
        this.filters = new ArrayList();
        for (SubscriptionsAPIFilter item : filters) {
          this.addToFilters(item);
        }
    } else {
      this.filters = null;
    }
    return (A) this;
  }
  
  public A withFilters(io.fabric8.knative.eventing.v1.SubscriptionsAPIFilter... filters) {
    if (this.filters != null) {
        this.filters.clear();
        _visitables.remove("filters");
    }
    if (filters != null) {
      for (SubscriptionsAPIFilter item : filters) {
        this.addToFilters(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasFilters() {
    return this.filters != null && !this.filters.isEmpty();
  }
  
  public FiltersNested<A> addNewFilter() {
    return new FiltersNested(-1, null);
  }
  
  public FiltersNested<A> addNewFilterLike(SubscriptionsAPIFilter item) {
    return new FiltersNested(-1, item);
  }
  
  public FiltersNested<A> setNewFilterLike(int index,SubscriptionsAPIFilter item) {
    return new FiltersNested(index, item);
  }
  
  public FiltersNested<A> editFilter(int index) {
    if (filters.size() <= index) throw new RuntimeException("Can't edit filters. Index exceeds size.");
    return setNewFilterLike(index, buildFilter(index));
  }
  
  public FiltersNested<A> editFirstFilter() {
    if (filters.size() == 0) throw new RuntimeException("Can't edit first filters. The list is empty.");
    return setNewFilterLike(0, buildFilter(0));
  }
  
  public FiltersNested<A> editLastFilter() {
    int index = filters.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last filters. The list is empty.");
    return setNewFilterLike(index, buildFilter(index));
  }
  
  public FiltersNested<A> editMatchingFilter(Predicate<SubscriptionsAPIFilterBuilder> predicate) {
    int index = -1;
    for (int i=0;i<filters.size();i++) { 
    if (predicate.test(filters.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching filters. No match found.");
    return setNewFilterLike(index, buildFilter(index));
  }
  
  public Destination buildSubscriber() {
    return this.subscriber != null ? this.subscriber.build() : null;
  }
  
  public A withSubscriber(Destination subscriber) {
    this._visitables.remove("subscriber");
    if (subscriber != null) {
        this.subscriber = new DestinationBuilder(subscriber);
        this._visitables.get("subscriber").add(this.subscriber);
    } else {
        this.subscriber = null;
        this._visitables.get("subscriber").remove(this.subscriber);
    }
    return (A) this;
  }
  
  public boolean hasSubscriber() {
    return this.subscriber != null;
  }
  
  public SubscriberNested<A> withNewSubscriber() {
    return new SubscriberNested(null);
  }
  
  public SubscriberNested<A> withNewSubscriberLike(Destination item) {
    return new SubscriberNested(item);
  }
  
  public SubscriberNested<A> editSubscriber() {
    return withNewSubscriberLike(java.util.Optional.ofNullable(buildSubscriber()).orElse(null));
  }
  
  public SubscriberNested<A> editOrNewSubscriber() {
    return withNewSubscriberLike(java.util.Optional.ofNullable(buildSubscriber()).orElse(new DestinationBuilder().build()));
  }
  
  public SubscriberNested<A> editOrNewSubscriberLike(Destination item) {
    return withNewSubscriberLike(java.util.Optional.ofNullable(buildSubscriber()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TriggerSpecFluent that = (TriggerSpecFluent) o;
    if (!java.util.Objects.equals(broker, that.broker)) return false;
    if (!java.util.Objects.equals(delivery, that.delivery)) return false;
    if (!java.util.Objects.equals(filter, that.filter)) return false;
    if (!java.util.Objects.equals(filters, that.filters)) return false;
    if (!java.util.Objects.equals(subscriber, that.subscriber)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(broker,  delivery,  filter,  filters,  subscriber,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (broker != null) { sb.append("broker:"); sb.append(broker + ","); }
    if (delivery != null) { sb.append("delivery:"); sb.append(delivery + ","); }
    if (filter != null) { sb.append("filter:"); sb.append(filter + ","); }
    if (filters != null && !filters.isEmpty()) { sb.append("filters:"); sb.append(filters + ","); }
    if (subscriber != null) { sb.append("subscriber:"); sb.append(subscriber + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class DeliveryNested<N> extends DeliverySpecFluent<DeliveryNested<N>> implements Nested<N>{
    DeliveryNested(DeliverySpec item) {
      this.builder = new DeliverySpecBuilder(this, item);
    }
    DeliverySpecBuilder builder;
    
    public N and() {
      return (N) TriggerSpecFluent.this.withDelivery(builder.build());
    }
    
    public N endDelivery() {
      return and();
    }
    
  
  }
  public class FilterNested<N> extends TriggerFilterFluent<FilterNested<N>> implements Nested<N>{
    FilterNested(TriggerFilter item) {
      this.builder = new TriggerFilterBuilder(this, item);
    }
    TriggerFilterBuilder builder;
    
    public N and() {
      return (N) TriggerSpecFluent.this.withFilter(builder.build());
    }
    
    public N endFilter() {
      return and();
    }
    
  
  }
  public class FiltersNested<N> extends SubscriptionsAPIFilterFluent<FiltersNested<N>> implements Nested<N>{
    FiltersNested(int index,SubscriptionsAPIFilter item) {
      this.index = index;
      this.builder = new SubscriptionsAPIFilterBuilder(this, item);
    }
    SubscriptionsAPIFilterBuilder builder;
    int index;
    
    public N and() {
      return (N) TriggerSpecFluent.this.setToFilters(index,builder.build());
    }
    
    public N endFilter() {
      return and();
    }
    
  
  }
  public class SubscriberNested<N> extends DestinationFluent<SubscriberNested<N>> implements Nested<N>{
    SubscriberNested(Destination item) {
      this.builder = new DestinationBuilder(this, item);
    }
    DestinationBuilder builder;
    
    public N and() {
      return (N) TriggerSpecFluent.this.withSubscriber(builder.build());
    }
    
    public N endSubscriber() {
      return and();
    }
    
  
  }

}