package io.fabric8.knative.eventing.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BrokerBuilder extends BrokerFluentImpl<BrokerBuilder> implements VisitableBuilder<Broker,BrokerBuilder>{
  public BrokerBuilder() {
    this(false);
  }
  public BrokerBuilder(Boolean validationEnabled) {
    this(new Broker(), validationEnabled);
  }
  public BrokerBuilder(BrokerFluent<?> fluent) {
    this(fluent, false);
  }
  public BrokerBuilder(BrokerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Broker(), validationEnabled);
  }
  public BrokerBuilder(BrokerFluent<?> fluent,Broker instance) {
    this(fluent, instance, false);
  }
  public BrokerBuilder(BrokerFluent<?> fluent,Broker instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public BrokerBuilder(Broker instance) {
    this(instance,false);
  }
  public BrokerBuilder(Broker instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  BrokerFluent<?> fluent;
  Boolean validationEnabled;
  public Broker build() {
    Broker buildable = new Broker(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}