package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConfigurationListBuilder extends ConfigurationListFluentImpl<ConfigurationListBuilder> implements VisitableBuilder<ConfigurationList,ConfigurationListBuilder>{
  public ConfigurationListBuilder() {
    this(false);
  }
  public ConfigurationListBuilder(Boolean validationEnabled) {
    this(new ConfigurationList(), validationEnabled);
  }
  public ConfigurationListBuilder(ConfigurationListFluent<?> fluent) {
    this(fluent, false);
  }
  public ConfigurationListBuilder(ConfigurationListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConfigurationList(), validationEnabled);
  }
  public ConfigurationListBuilder(ConfigurationListFluent<?> fluent,ConfigurationList instance) {
    this(fluent, instance, false);
  }
  public ConfigurationListBuilder(ConfigurationListFluent<?> fluent,ConfigurationList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  public ConfigurationListBuilder(ConfigurationList instance) {
    this(instance,false);
  }
  public ConfigurationListBuilder(ConfigurationList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  ConfigurationListFluent<?> fluent;
  Boolean validationEnabled;
  public ConfigurationList build() {
    ConfigurationList buildable = new ConfigurationList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}