package io.fabric8.knative.flows.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ParallelChannelStatusBuilder extends ParallelChannelStatusFluentImpl<ParallelChannelStatusBuilder> implements VisitableBuilder<ParallelChannelStatus,ParallelChannelStatusBuilder>{
  public ParallelChannelStatusBuilder() {
    this(false);
  }
  public ParallelChannelStatusBuilder(Boolean validationEnabled) {
    this(new ParallelChannelStatus(), validationEnabled);
  }
  public ParallelChannelStatusBuilder(ParallelChannelStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ParallelChannelStatusBuilder(ParallelChannelStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ParallelChannelStatus(), validationEnabled);
  }
  public ParallelChannelStatusBuilder(ParallelChannelStatusFluent<?> fluent,ParallelChannelStatus instance) {
    this(fluent, instance, false);
  }
  public ParallelChannelStatusBuilder(ParallelChannelStatusFluent<?> fluent,ParallelChannelStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withChannel(instance.getChannel()); 
    fluent.withReady(instance.getReady()); 
    this.validationEnabled = validationEnabled; 
  }
  public ParallelChannelStatusBuilder(ParallelChannelStatus instance) {
    this(instance,false);
  }
  public ParallelChannelStatusBuilder(ParallelChannelStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withChannel(instance.getChannel()); 
    this.withReady(instance.getReady()); 
    this.validationEnabled = validationEnabled; 
  }
  ParallelChannelStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ParallelChannelStatus build() {
    ParallelChannelStatus buildable = new ParallelChannelStatus(fluent.getChannel(),fluent.getReady());
    return buildable;
  }
  
}