package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceListBuilder extends ServiceListFluentImpl<ServiceListBuilder> implements VisitableBuilder<ServiceList,ServiceListBuilder>{
  public ServiceListBuilder() {
    this(false);
  }
  public ServiceListBuilder(Boolean validationEnabled) {
    this(new ServiceList(), validationEnabled);
  }
  public ServiceListBuilder(ServiceListFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceListBuilder(ServiceListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceList(), validationEnabled);
  }
  public ServiceListBuilder(ServiceListFluent<?> fluent,ServiceList instance) {
    this(fluent, instance, false);
  }
  public ServiceListBuilder(ServiceListFluent<?> fluent,ServiceList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  public ServiceListBuilder(ServiceList instance) {
    this(instance,false);
  }
  public ServiceListBuilder(ServiceList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  ServiceListFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceList build() {
    ServiceList buildable = new ServiceList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}