package io.fabric8.knative.eventing.contrib.awssqs.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AwsSqsSourceListBuilder extends AwsSqsSourceListFluentImpl<AwsSqsSourceListBuilder> implements VisitableBuilder<AwsSqsSourceList,AwsSqsSourceListBuilder>{
  public AwsSqsSourceListBuilder() {
    this(false);
  }
  public AwsSqsSourceListBuilder(Boolean validationEnabled) {
    this(new AwsSqsSourceList(), validationEnabled);
  }
  public AwsSqsSourceListBuilder(AwsSqsSourceListFluent<?> fluent) {
    this(fluent, false);
  }
  public AwsSqsSourceListBuilder(AwsSqsSourceListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AwsSqsSourceList(), validationEnabled);
  }
  public AwsSqsSourceListBuilder(AwsSqsSourceListFluent<?> fluent,AwsSqsSourceList instance) {
    this(fluent, instance, false);
  }
  public AwsSqsSourceListBuilder(AwsSqsSourceListFluent<?> fluent,AwsSqsSourceList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  public AwsSqsSourceListBuilder(AwsSqsSourceList instance) {
    this(instance,false);
  }
  public AwsSqsSourceListBuilder(AwsSqsSourceList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  AwsSqsSourceListFluent<?> fluent;
  Boolean validationEnabled;
  public AwsSqsSourceList build() {
    AwsSqsSourceList buildable = new AwsSqsSourceList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}