package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaSASLSpecBuilder extends KafkaSASLSpecFluentImpl<KafkaSASLSpecBuilder> implements VisitableBuilder<KafkaSASLSpec,KafkaSASLSpecBuilder>{
  public KafkaSASLSpecBuilder() {
    this(false);
  }
  public KafkaSASLSpecBuilder(Boolean validationEnabled) {
    this(new KafkaSASLSpec(), validationEnabled);
  }
  public KafkaSASLSpecBuilder(KafkaSASLSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaSASLSpecBuilder(KafkaSASLSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaSASLSpec(), validationEnabled);
  }
  public KafkaSASLSpecBuilder(KafkaSASLSpecFluent<?> fluent,KafkaSASLSpec instance) {
    this(fluent, instance, false);
  }
  public KafkaSASLSpecBuilder(KafkaSASLSpecFluent<?> fluent,KafkaSASLSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withEnable(instance.getEnable()); 
    fluent.withPassword(instance.getPassword()); 
    fluent.withType(instance.getType()); 
    fluent.withUser(instance.getUser()); 
    this.validationEnabled = validationEnabled; 
  }
  public KafkaSASLSpecBuilder(KafkaSASLSpec instance) {
    this(instance,false);
  }
  public KafkaSASLSpecBuilder(KafkaSASLSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withEnable(instance.getEnable()); 
    this.withPassword(instance.getPassword()); 
    this.withType(instance.getType()); 
    this.withUser(instance.getUser()); 
    this.validationEnabled = validationEnabled; 
  }
  KafkaSASLSpecFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaSASLSpec build() {
    KafkaSASLSpec buildable = new KafkaSASLSpec(fluent.getEnable(),fluent.getPassword(),fluent.getType(),fluent.getUser());
    return buildable;
  }
  
}