package io.fabric8.knative.eventing.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BrokerStatusBuilder extends BrokerStatusFluentImpl<BrokerStatusBuilder> implements VisitableBuilder<BrokerStatus,BrokerStatusBuilder>{
  public BrokerStatusBuilder() {
    this(false);
  }
  public BrokerStatusBuilder(Boolean validationEnabled) {
    this(new BrokerStatus(), validationEnabled);
  }
  public BrokerStatusBuilder(BrokerStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public BrokerStatusBuilder(BrokerStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BrokerStatus(), validationEnabled);
  }
  public BrokerStatusBuilder(BrokerStatusFluent<?> fluent,BrokerStatus instance) {
    this(fluent, instance, false);
  }
  public BrokerStatusBuilder(BrokerStatusFluent<?> fluent,BrokerStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAddress(instance.getAddress()); 
    fluent.withAnnotations(instance.getAnnotations()); 
    fluent.withConditions(instance.getConditions()); 
    fluent.withDeadLetterSinkUri(instance.getDeadLetterSinkUri()); 
    fluent.withObservedGeneration(instance.getObservedGeneration()); 
    this.validationEnabled = validationEnabled; 
  }
  public BrokerStatusBuilder(BrokerStatus instance) {
    this(instance,false);
  }
  public BrokerStatusBuilder(BrokerStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAddress(instance.getAddress()); 
    this.withAnnotations(instance.getAnnotations()); 
    this.withConditions(instance.getConditions()); 
    this.withDeadLetterSinkUri(instance.getDeadLetterSinkUri()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
    this.validationEnabled = validationEnabled; 
  }
  BrokerStatusFluent<?> fluent;
  Boolean validationEnabled;
  public BrokerStatus build() {
    BrokerStatus buildable = new BrokerStatus(fluent.getAddress(),fluent.getAnnotations(),fluent.getConditions(),fluent.getDeadLetterSinkUri(),fluent.getObservedGeneration());
    return buildable;
  }
  
}