package io.fabric8.knative.messaging.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class InMemoryChannelStatusBuilder extends InMemoryChannelStatusFluentImpl<InMemoryChannelStatusBuilder> implements VisitableBuilder<InMemoryChannelStatus,InMemoryChannelStatusBuilder>{
  public InMemoryChannelStatusBuilder() {
    this(false);
  }
  public InMemoryChannelStatusBuilder(Boolean validationEnabled) {
    this(new InMemoryChannelStatus(), validationEnabled);
  }
  public InMemoryChannelStatusBuilder(InMemoryChannelStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public InMemoryChannelStatusBuilder(InMemoryChannelStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new InMemoryChannelStatus(), validationEnabled);
  }
  public InMemoryChannelStatusBuilder(InMemoryChannelStatusFluent<?> fluent,InMemoryChannelStatus instance) {
    this(fluent, instance, false);
  }
  public InMemoryChannelStatusBuilder(InMemoryChannelStatusFluent<?> fluent,InMemoryChannelStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAddress(instance.getAddress()); 
    fluent.withAnnotations(instance.getAnnotations()); 
    fluent.withConditions(instance.getConditions()); 
    fluent.withDeadLetterChannel(instance.getDeadLetterChannel()); 
    fluent.withDeadLetterSinkUri(instance.getDeadLetterSinkUri()); 
    fluent.withObservedGeneration(instance.getObservedGeneration()); 
    fluent.withSubscribers(instance.getSubscribers()); 
    this.validationEnabled = validationEnabled; 
  }
  public InMemoryChannelStatusBuilder(InMemoryChannelStatus instance) {
    this(instance,false);
  }
  public InMemoryChannelStatusBuilder(InMemoryChannelStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAddress(instance.getAddress()); 
    this.withAnnotations(instance.getAnnotations()); 
    this.withConditions(instance.getConditions()); 
    this.withDeadLetterChannel(instance.getDeadLetterChannel()); 
    this.withDeadLetterSinkUri(instance.getDeadLetterSinkUri()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
    this.withSubscribers(instance.getSubscribers()); 
    this.validationEnabled = validationEnabled; 
  }
  InMemoryChannelStatusFluent<?> fluent;
  Boolean validationEnabled;
  public InMemoryChannelStatus build() {
    InMemoryChannelStatus buildable = new InMemoryChannelStatus(fluent.getAddress(),fluent.getAnnotations(),fluent.getConditions(),fluent.getDeadLetterChannel(),fluent.getDeadLetterSinkUri(),fluent.getObservedGeneration(),fluent.getSubscribers());
    return buildable;
  }
  
}