package io.fabric8.knative.eventing.contrib.couchdb.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CouchDbSourceListBuilder extends CouchDbSourceListFluentImpl<CouchDbSourceListBuilder> implements VisitableBuilder<CouchDbSourceList,CouchDbSourceListBuilder>{
  public CouchDbSourceListBuilder() {
    this(false);
  }
  public CouchDbSourceListBuilder(Boolean validationEnabled) {
    this(new CouchDbSourceList(), validationEnabled);
  }
  public CouchDbSourceListBuilder(CouchDbSourceListFluent<?> fluent) {
    this(fluent, false);
  }
  public CouchDbSourceListBuilder(CouchDbSourceListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CouchDbSourceList(), validationEnabled);
  }
  public CouchDbSourceListBuilder(CouchDbSourceListFluent<?> fluent,CouchDbSourceList instance) {
    this(fluent, instance, false);
  }
  public CouchDbSourceListBuilder(CouchDbSourceListFluent<?> fluent,CouchDbSourceList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  public CouchDbSourceListBuilder(CouchDbSourceList instance) {
    this(instance,false);
  }
  public CouchDbSourceListBuilder(CouchDbSourceList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  CouchDbSourceListFluent<?> fluent;
  Boolean validationEnabled;
  public CouchDbSourceList build() {
    CouchDbSourceList buildable = new CouchDbSourceList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}