package io.fabric8.knative.sources.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ContainerSourceStatusBuilder extends ContainerSourceStatusFluentImpl<ContainerSourceStatusBuilder> implements VisitableBuilder<ContainerSourceStatus,ContainerSourceStatusBuilder>{
  public ContainerSourceStatusBuilder() {
    this(false);
  }
  public ContainerSourceStatusBuilder(Boolean validationEnabled) {
    this(new ContainerSourceStatus(), validationEnabled);
  }
  public ContainerSourceStatusBuilder(ContainerSourceStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ContainerSourceStatusBuilder(ContainerSourceStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ContainerSourceStatus(), validationEnabled);
  }
  public ContainerSourceStatusBuilder(ContainerSourceStatusFluent<?> fluent,ContainerSourceStatus instance) {
    this(fluent, instance, false);
  }
  public ContainerSourceStatusBuilder(ContainerSourceStatusFluent<?> fluent,ContainerSourceStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAnnotations(instance.getAnnotations()); 
    fluent.withCeAttributes(instance.getCeAttributes()); 
    fluent.withConditions(instance.getConditions()); 
    fluent.withObservedGeneration(instance.getObservedGeneration()); 
    fluent.withSinkUri(instance.getSinkUri()); 
    this.validationEnabled = validationEnabled; 
  }
  public ContainerSourceStatusBuilder(ContainerSourceStatus instance) {
    this(instance,false);
  }
  public ContainerSourceStatusBuilder(ContainerSourceStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAnnotations(instance.getAnnotations()); 
    this.withCeAttributes(instance.getCeAttributes()); 
    this.withConditions(instance.getConditions()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
    this.withSinkUri(instance.getSinkUri()); 
    this.validationEnabled = validationEnabled; 
  }
  ContainerSourceStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ContainerSourceStatus build() {
    ContainerSourceStatus buildable = new ContainerSourceStatus(fluent.getAnnotations(),fluent.getCeAttributes(),fluent.getConditions(),fluent.getObservedGeneration(),fluent.getSinkUri());
    return buildable;
  }
  
}