package io.fabric8.knative.eventing.contrib.github.v1alpha1;

import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventAttributesBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventAttributes;
import java.lang.Boolean;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventAttributesFluentImpl;
import io.fabric8.knative.internal.pkg.apis.Condition;
import java.lang.Integer;
import io.fabric8.knative.internal.pkg.apis.ConditionBuilder;
import io.fabric8.knative.internal.pkg.apis.ConditionFluentImpl;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class GitHubSourceStatusFluentImpl<A extends GitHubSourceStatusFluent<A>> extends BaseFluent<A> implements GitHubSourceStatusFluent<A>{
  public GitHubSourceStatusFluentImpl() {
  }
  public GitHubSourceStatusFluentImpl(GitHubSourceStatus instance) {
    this.withAnnotations(instance.getAnnotations()); 
    this.withCeAttributes(instance.getCeAttributes()); 
    this.withConditions(instance.getConditions()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
    this.withSinkUri(instance.getSinkUri()); 
    this.withWebhookIDKey(instance.getWebhookIDKey()); 
  }
  private Map<String,String> annotations;
  private ArrayList<CloudEventAttributesBuilder> ceAttributes = new ArrayList<CloudEventAttributesBuilder>();
  private ArrayList<ConditionBuilder> conditions = new ArrayList<ConditionBuilder>();
  private Long observedGeneration;
  private String sinkUri;
  private String webhookIDKey;
  public A addToAnnotations(String key,String value) {
    if(this.annotations == null && key != null && value != null) { this.annotations = new LinkedHashMap(); }
    if(key != null && value != null) {this.annotations.put(key, value);} return (A)this;
  }
  public A addToAnnotations(Map<String,String> map) {
    if(this.annotations == null && map != null) { this.annotations = new LinkedHashMap(); }
    if(map != null) { this.annotations.putAll(map);} return (A)this;
  }
  public A removeFromAnnotations(String key) {
    if(this.annotations == null) { return (A) this; }
    if(key != null && this.annotations != null) {this.annotations.remove(key);} return (A)this;
  }
  public A removeFromAnnotations(Map<String,String> map) {
    if(this.annotations == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.annotations != null){this.annotations.remove(key);}}} return (A)this;
  }
  public Map<String,String> getAnnotations() {
    return this.annotations;
  }
  public <K,V>A withAnnotations(Map<String,String> annotations) {
    if (annotations == null) { this.annotations =  null;} else {this.annotations = new LinkedHashMap(annotations);} return (A) this;
  }
  public Boolean hasAnnotations() {
    return this.annotations != null;
  }
  public A addToCeAttributes(Integer index,CloudEventAttributes item) {
    if (this.ceAttributes == null) {this.ceAttributes = new ArrayList<CloudEventAttributesBuilder>();}
    CloudEventAttributesBuilder builder = new CloudEventAttributesBuilder(item);_visitables.get("ceAttributes").add(index >= 0 ? index : _visitables.get("ceAttributes").size(), builder);this.ceAttributes.add(index >= 0 ? index : ceAttributes.size(), builder); return (A)this;
  }
  public A setToCeAttributes(Integer index,CloudEventAttributes item) {
    if (this.ceAttributes == null) {this.ceAttributes = new ArrayList<CloudEventAttributesBuilder>();}
    CloudEventAttributesBuilder builder = new CloudEventAttributesBuilder(item);
    if (index < 0 || index >= _visitables.get("ceAttributes").size()) { _visitables.get("ceAttributes").add(builder); } else { _visitables.get("ceAttributes").set(index, builder);}
    if (index < 0 || index >= ceAttributes.size()) { ceAttributes.add(builder); } else { ceAttributes.set(index, builder);}
     return (A)this;
  }
  public A addToCeAttributes(io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventAttributes... items) {
    if (this.ceAttributes == null) {this.ceAttributes = new ArrayList<CloudEventAttributesBuilder>();}
    for (CloudEventAttributes item : items) {CloudEventAttributesBuilder builder = new CloudEventAttributesBuilder(item);_visitables.get("ceAttributes").add(builder);this.ceAttributes.add(builder);} return (A)this;
  }
  public A addAllToCeAttributes(Collection<CloudEventAttributes> items) {
    if (this.ceAttributes == null) {this.ceAttributes = new ArrayList<CloudEventAttributesBuilder>();}
    for (CloudEventAttributes item : items) {CloudEventAttributesBuilder builder = new CloudEventAttributesBuilder(item);_visitables.get("ceAttributes").add(builder);this.ceAttributes.add(builder);} return (A)this;
  }
  public A removeFromCeAttributes(io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventAttributes... items) {
    for (CloudEventAttributes item : items) {CloudEventAttributesBuilder builder = new CloudEventAttributesBuilder(item);_visitables.get("ceAttributes").remove(builder);if (this.ceAttributes != null) {this.ceAttributes.remove(builder);}} return (A)this;
  }
  public A removeAllFromCeAttributes(Collection<CloudEventAttributes> items) {
    for (CloudEventAttributes item : items) {CloudEventAttributesBuilder builder = new CloudEventAttributesBuilder(item);_visitables.get("ceAttributes").remove(builder);if (this.ceAttributes != null) {this.ceAttributes.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromCeAttributes(Predicate<CloudEventAttributesBuilder> predicate) {
    if (ceAttributes == null) return (A) this;
    final Iterator<CloudEventAttributesBuilder> each = ceAttributes.iterator();
    final List visitables = _visitables.get("ceAttributes");
    while (each.hasNext()) {
      CloudEventAttributesBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildCeAttributes instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<CloudEventAttributes> getCeAttributes() {
    return ceAttributes != null ? build(ceAttributes) : null;
  }
  public List<CloudEventAttributes> buildCeAttributes() {
    return ceAttributes != null ? build(ceAttributes) : null;
  }
  public CloudEventAttributes buildCeAttribute(Integer index) {
    return this.ceAttributes.get(index).build();
  }
  public CloudEventAttributes buildFirstCeAttribute() {
    return this.ceAttributes.get(0).build();
  }
  public CloudEventAttributes buildLastCeAttribute() {
    return this.ceAttributes.get(ceAttributes.size() - 1).build();
  }
  public CloudEventAttributes buildMatchingCeAttribute(Predicate<CloudEventAttributesBuilder> predicate) {
    for (CloudEventAttributesBuilder item: ceAttributes) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCeAttribute(Predicate<CloudEventAttributesBuilder> predicate) {
    for (CloudEventAttributesBuilder item: ceAttributes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withCeAttributes(List<CloudEventAttributes> ceAttributes) {
    if (this.ceAttributes != null) { _visitables.get("ceAttributes").removeAll(this.ceAttributes);}
    if (ceAttributes != null) {this.ceAttributes = new ArrayList(); for (CloudEventAttributes item : ceAttributes){this.addToCeAttributes(item);}} else { this.ceAttributes = null;} return (A) this;
  }
  public A withCeAttributes(io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventAttributes... ceAttributes) {
    if (this.ceAttributes != null) {this.ceAttributes.clear();}
    if (ceAttributes != null) {for (CloudEventAttributes item :ceAttributes){ this.addToCeAttributes(item);}} return (A) this;
  }
  public Boolean hasCeAttributes() {
    return ceAttributes != null && !ceAttributes.isEmpty();
  }
  public A addNewCeAttribute(String source,String type) {
    return (A)addToCeAttributes(new CloudEventAttributes(source, type));
  }
  public GitHubSourceStatusFluent.CeAttributesNested<A> addNewCeAttribute() {
    return new GitHubSourceStatusFluentImpl.CeAttributesNestedImpl();
  }
  public GitHubSourceStatusFluent.CeAttributesNested<A> addNewCeAttributeLike(CloudEventAttributes item) {
    return new GitHubSourceStatusFluentImpl.CeAttributesNestedImpl(-1, item);
  }
  public GitHubSourceStatusFluent.CeAttributesNested<A> setNewCeAttributeLike(Integer index,CloudEventAttributes item) {
    return new GitHubSourceStatusFluentImpl.CeAttributesNestedImpl(index, item);
  }
  public GitHubSourceStatusFluent.CeAttributesNested<A> editCeAttribute(Integer index) {
    if (ceAttributes.size() <= index) throw new RuntimeException("Can't edit ceAttributes. Index exceeds size.");
    return setNewCeAttributeLike(index, buildCeAttribute(index));
  }
  public GitHubSourceStatusFluent.CeAttributesNested<A> editFirstCeAttribute() {
    if (ceAttributes.size() == 0) throw new RuntimeException("Can't edit first ceAttributes. The list is empty.");
    return setNewCeAttributeLike(0, buildCeAttribute(0));
  }
  public GitHubSourceStatusFluent.CeAttributesNested<A> editLastCeAttribute() {
    int index = ceAttributes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last ceAttributes. The list is empty.");
    return setNewCeAttributeLike(index, buildCeAttribute(index));
  }
  public GitHubSourceStatusFluent.CeAttributesNested<A> editMatchingCeAttribute(Predicate<CloudEventAttributesBuilder> predicate) {
    int index = -1;
    for (int i=0;i<ceAttributes.size();i++) { 
    if (predicate.test(ceAttributes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching ceAttributes. No match found.");
    return setNewCeAttributeLike(index, buildCeAttribute(index));
  }
  public A addToConditions(Integer index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(Integer index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    ConditionBuilder builder = new ConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.knative.internal.pkg.apis.Condition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<Condition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.knative.internal.pkg.apis.Condition... items) {
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<Condition> items) {
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<ConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      ConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Condition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<Condition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public Condition buildCondition(Integer index) {
    return this.conditions.get(index).build();
  }
  public Condition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public Condition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate) {
    for (ConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate) {
    for (ConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<Condition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new ArrayList(); for (Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.knative.internal.pkg.apis.Condition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (Condition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public GitHubSourceStatusFluent.ConditionsNested<A> addNewCondition() {
    return new GitHubSourceStatusFluentImpl.ConditionsNestedImpl();
  }
  public GitHubSourceStatusFluent.ConditionsNested<A> addNewConditionLike(Condition item) {
    return new GitHubSourceStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public GitHubSourceStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index,Condition item) {
    return new GitHubSourceStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public GitHubSourceStatusFluent.ConditionsNested<A> editCondition(Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public GitHubSourceStatusFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public GitHubSourceStatusFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public GitHubSourceStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public Long getObservedGeneration() {
    return this.observedGeneration;
  }
  public A withObservedGeneration(Long observedGeneration) {
    this.observedGeneration=observedGeneration; return (A) this;
  }
  public Boolean hasObservedGeneration() {
    return this.observedGeneration != null;
  }
  public String getSinkUri() {
    return this.sinkUri;
  }
  public A withSinkUri(String sinkUri) {
    this.sinkUri=sinkUri; return (A) this;
  }
  public Boolean hasSinkUri() {
    return this.sinkUri != null;
  }
  public String getWebhookIDKey() {
    return this.webhookIDKey;
  }
  public A withWebhookIDKey(String webhookIDKey) {
    this.webhookIDKey=webhookIDKey; return (A) this;
  }
  public Boolean hasWebhookIDKey() {
    return this.webhookIDKey != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GitHubSourceStatusFluentImpl that = (GitHubSourceStatusFluentImpl) o;
    if (annotations != null ? !annotations.equals(that.annotations) :that.annotations != null) return false;
    if (ceAttributes != null ? !ceAttributes.equals(that.ceAttributes) :that.ceAttributes != null) return false;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
    if (sinkUri != null ? !sinkUri.equals(that.sinkUri) :that.sinkUri != null) return false;
    if (webhookIDKey != null ? !webhookIDKey.equals(that.webhookIDKey) :that.webhookIDKey != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(annotations,  ceAttributes,  conditions,  observedGeneration,  sinkUri,  webhookIDKey,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (annotations != null && !annotations.isEmpty()) { sb.append("annotations:"); sb.append(annotations + ","); }
    if (ceAttributes != null && !ceAttributes.isEmpty()) { sb.append("ceAttributes:"); sb.append(ceAttributes + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (observedGeneration != null) { sb.append("observedGeneration:"); sb.append(observedGeneration + ","); }
    if (sinkUri != null) { sb.append("sinkUri:"); sb.append(sinkUri + ","); }
    if (webhookIDKey != null) { sb.append("webhookIDKey:"); sb.append(webhookIDKey); }
    sb.append("}");
    return sb.toString();
  }
  class CeAttributesNestedImpl<N> extends CloudEventAttributesFluentImpl<GitHubSourceStatusFluent.CeAttributesNested<N>> implements GitHubSourceStatusFluent.CeAttributesNested<N>,Nested<N>{
    CeAttributesNestedImpl(Integer index,CloudEventAttributes item) {
      this.index = index;
      this.builder = new CloudEventAttributesBuilder(this, item);
    }
    CeAttributesNestedImpl() {
      this.index = -1;
      this.builder = new CloudEventAttributesBuilder(this);
    }
    CloudEventAttributesBuilder builder;
    Integer index;
    public N and() {
      return (N) GitHubSourceStatusFluentImpl.this.setToCeAttributes(index,builder.build());
    }
    public N endCeAttribute() {
      return and();
    }
    
  }
  class ConditionsNestedImpl<N> extends ConditionFluentImpl<GitHubSourceStatusFluent.ConditionsNested<N>> implements GitHubSourceStatusFluent.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(Integer index,Condition item) {
      this.index = index;
      this.builder = new ConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new ConditionBuilder(this);
    }
    ConditionBuilder builder;
    Integer index;
    public N and() {
      return (N) GitHubSourceStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  
}