package io.fabric8.knative.eventing.contrib.gitlab.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SecretValueFromSourceBuilder extends SecretValueFromSourceFluentImpl<SecretValueFromSourceBuilder> implements VisitableBuilder<SecretValueFromSource,SecretValueFromSourceBuilder>{
  public SecretValueFromSourceBuilder() {
    this(false);
  }
  public SecretValueFromSourceBuilder(Boolean validationEnabled) {
    this(new SecretValueFromSource(), validationEnabled);
  }
  public SecretValueFromSourceBuilder(SecretValueFromSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public SecretValueFromSourceBuilder(SecretValueFromSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SecretValueFromSource(), validationEnabled);
  }
  public SecretValueFromSourceBuilder(SecretValueFromSourceFluent<?> fluent,SecretValueFromSource instance) {
    this(fluent, instance, false);
  }
  public SecretValueFromSourceBuilder(SecretValueFromSourceFluent<?> fluent,SecretValueFromSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withSecretKeyRef(instance.getSecretKeyRef()); 
    this.validationEnabled = validationEnabled; 
  }
  public SecretValueFromSourceBuilder(SecretValueFromSource instance) {
    this(instance,false);
  }
  public SecretValueFromSourceBuilder(SecretValueFromSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withSecretKeyRef(instance.getSecretKeyRef()); 
    this.validationEnabled = validationEnabled; 
  }
  SecretValueFromSourceFluent<?> fluent;
  Boolean validationEnabled;
  public SecretValueFromSource build() {
    SecretValueFromSource buildable = new SecretValueFromSource(fluent.getSecretKeyRef());
    return buildable;
  }
  
}