package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaBindingStatusBuilder extends KafkaBindingStatusFluentImpl<KafkaBindingStatusBuilder> implements VisitableBuilder<KafkaBindingStatus,KafkaBindingStatusBuilder>{
  public KafkaBindingStatusBuilder() {
    this(false);
  }
  public KafkaBindingStatusBuilder(Boolean validationEnabled) {
    this(new KafkaBindingStatus(), validationEnabled);
  }
  public KafkaBindingStatusBuilder(KafkaBindingStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaBindingStatusBuilder(KafkaBindingStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaBindingStatus(), validationEnabled);
  }
  public KafkaBindingStatusBuilder(KafkaBindingStatusFluent<?> fluent,KafkaBindingStatus instance) {
    this(fluent, instance, false);
  }
  public KafkaBindingStatusBuilder(KafkaBindingStatusFluent<?> fluent,KafkaBindingStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAnnotations(instance.getAnnotations()); 
    fluent.withConditions(instance.getConditions()); 
    fluent.withObservedGeneration(instance.getObservedGeneration()); 
    this.validationEnabled = validationEnabled; 
  }
  public KafkaBindingStatusBuilder(KafkaBindingStatus instance) {
    this(instance,false);
  }
  public KafkaBindingStatusBuilder(KafkaBindingStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAnnotations(instance.getAnnotations()); 
    this.withConditions(instance.getConditions()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
    this.validationEnabled = validationEnabled; 
  }
  KafkaBindingStatusFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaBindingStatus build() {
    KafkaBindingStatus buildable = new KafkaBindingStatus(fluent.getAnnotations(),fluent.getConditions(),fluent.getObservedGeneration());
    return buildable;
  }
  
}