package io.fabric8.knative.messaging.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SubscriptionStatusPhysicalSubscriptionBuilder extends SubscriptionStatusPhysicalSubscriptionFluentImpl<SubscriptionStatusPhysicalSubscriptionBuilder> implements VisitableBuilder<SubscriptionStatusPhysicalSubscription,SubscriptionStatusPhysicalSubscriptionBuilder>{
  public SubscriptionStatusPhysicalSubscriptionBuilder() {
    this(false);
  }
  public SubscriptionStatusPhysicalSubscriptionBuilder(Boolean validationEnabled) {
    this(new SubscriptionStatusPhysicalSubscription(), validationEnabled);
  }
  public SubscriptionStatusPhysicalSubscriptionBuilder(SubscriptionStatusPhysicalSubscriptionFluent<?> fluent) {
    this(fluent, false);
  }
  public SubscriptionStatusPhysicalSubscriptionBuilder(SubscriptionStatusPhysicalSubscriptionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SubscriptionStatusPhysicalSubscription(), validationEnabled);
  }
  public SubscriptionStatusPhysicalSubscriptionBuilder(SubscriptionStatusPhysicalSubscriptionFluent<?> fluent,SubscriptionStatusPhysicalSubscription instance) {
    this(fluent, instance, false);
  }
  public SubscriptionStatusPhysicalSubscriptionBuilder(SubscriptionStatusPhysicalSubscriptionFluent<?> fluent,SubscriptionStatusPhysicalSubscription instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDeadLetterSinkUri(instance.getDeadLetterSinkUri()); 
    fluent.withReplyUri(instance.getReplyUri()); 
    fluent.withSubscriberUri(instance.getSubscriberUri()); 
    this.validationEnabled = validationEnabled; 
  }
  public SubscriptionStatusPhysicalSubscriptionBuilder(SubscriptionStatusPhysicalSubscription instance) {
    this(instance,false);
  }
  public SubscriptionStatusPhysicalSubscriptionBuilder(SubscriptionStatusPhysicalSubscription instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withDeadLetterSinkUri(instance.getDeadLetterSinkUri()); 
    this.withReplyUri(instance.getReplyUri()); 
    this.withSubscriberUri(instance.getSubscriberUri()); 
    this.validationEnabled = validationEnabled; 
  }
  SubscriptionStatusPhysicalSubscriptionFluent<?> fluent;
  Boolean validationEnabled;
  public SubscriptionStatusPhysicalSubscription build() {
    SubscriptionStatusPhysicalSubscription buildable = new SubscriptionStatusPhysicalSubscription(fluent.getDeadLetterSinkUri(),fluent.getReplyUri(),fluent.getSubscriberUri());
    return buildable;
  }
  
}