package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.knative.internal.pkg.tracker.ReferenceFluentImpl;
import io.fabric8.knative.internal.pkg.tracker.Reference;
import java.lang.Integer;
import io.fabric8.knative.internal.pkg.tracker.ReferenceBuilder;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class KafkaBindingSpecFluentImpl<A extends KafkaBindingSpecFluent<A>> extends BaseFluent<A> implements KafkaBindingSpecFluent<A>{
  public KafkaBindingSpecFluentImpl() {
  }
  public KafkaBindingSpecFluentImpl(KafkaBindingSpec instance) {
    this.withBootstrapServers(instance.getBootstrapServers()); 
    this.withNet(instance.getNet()); 
    this.withSubject(instance.getSubject()); 
  }
  private List<String> bootstrapServers = new ArrayList<String>();
  private KafkaNetSpecBuilder net;
  private ReferenceBuilder subject;
  public A addToBootstrapServers(Integer index,String item) {
    if (this.bootstrapServers == null) {this.bootstrapServers = new ArrayList<String>();}
    this.bootstrapServers.add(index, item);
    return (A)this;
  }
  public A setToBootstrapServers(Integer index,String item) {
    if (this.bootstrapServers == null) {this.bootstrapServers = new ArrayList<String>();}
    this.bootstrapServers.set(index, item); return (A)this;
  }
  public A addToBootstrapServers(java.lang.String... items) {
    if (this.bootstrapServers == null) {this.bootstrapServers = new ArrayList<String>();}
    for (String item : items) {this.bootstrapServers.add(item);} return (A)this;
  }
  public A addAllToBootstrapServers(Collection<String> items) {
    if (this.bootstrapServers == null) {this.bootstrapServers = new ArrayList<String>();}
    for (String item : items) {this.bootstrapServers.add(item);} return (A)this;
  }
  public A removeFromBootstrapServers(java.lang.String... items) {
    for (String item : items) {if (this.bootstrapServers!= null){ this.bootstrapServers.remove(item);}} return (A)this;
  }
  public A removeAllFromBootstrapServers(Collection<String> items) {
    for (String item : items) {if (this.bootstrapServers!= null){ this.bootstrapServers.remove(item);}} return (A)this;
  }
  public List<String> getBootstrapServers() {
    return this.bootstrapServers;
  }
  public String getBootstrapServer(Integer index) {
    return this.bootstrapServers.get(index);
  }
  public String getFirstBootstrapServer() {
    return this.bootstrapServers.get(0);
  }
  public String getLastBootstrapServer() {
    return this.bootstrapServers.get(bootstrapServers.size() - 1);
  }
  public String getMatchingBootstrapServer(Predicate<String> predicate) {
    for (String item: bootstrapServers) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingBootstrapServer(Predicate<String> predicate) {
    for (String item: bootstrapServers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withBootstrapServers(List<String> bootstrapServers) {
    if (bootstrapServers != null) {this.bootstrapServers = new ArrayList(); for (String item : bootstrapServers){this.addToBootstrapServers(item);}} else { this.bootstrapServers = null;} return (A) this;
  }
  public A withBootstrapServers(java.lang.String... bootstrapServers) {
    if (this.bootstrapServers != null) {this.bootstrapServers.clear();}
    if (bootstrapServers != null) {for (String item :bootstrapServers){ this.addToBootstrapServers(item);}} return (A) this;
  }
  public Boolean hasBootstrapServers() {
    return bootstrapServers != null && !bootstrapServers.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildNet instead.
   * @return The buildable object.
   */
  @Deprecated
  public KafkaNetSpec getNet() {
    return this.net!=null ?this.net.build():null;
  }
  public KafkaNetSpec buildNet() {
    return this.net!=null ?this.net.build():null;
  }
  public A withNet(KafkaNetSpec net) {
    _visitables.get("net").remove(this.net);
    if (net!=null){ this.net= new KafkaNetSpecBuilder(net); _visitables.get("net").add(this.net);} else { this.net = null; _visitables.get("net").remove(this.net); } return (A) this;
  }
  public Boolean hasNet() {
    return this.net != null;
  }
  public KafkaBindingSpecFluent.NetNested<A> withNewNet() {
    return new KafkaBindingSpecFluentImpl.NetNestedImpl();
  }
  public KafkaBindingSpecFluent.NetNested<A> withNewNetLike(KafkaNetSpec item) {
    return new KafkaBindingSpecFluentImpl.NetNestedImpl(item);
  }
  public KafkaBindingSpecFluent.NetNested<A> editNet() {
    return withNewNetLike(getNet());
  }
  public KafkaBindingSpecFluent.NetNested<A> editOrNewNet() {
    return withNewNetLike(getNet() != null ? getNet(): new KafkaNetSpecBuilder().build());
  }
  public KafkaBindingSpecFluent.NetNested<A> editOrNewNetLike(KafkaNetSpec item) {
    return withNewNetLike(getNet() != null ? getNet(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSubject instead.
   * @return The buildable object.
   */
  @Deprecated
  public Reference getSubject() {
    return this.subject!=null ?this.subject.build():null;
  }
  public Reference buildSubject() {
    return this.subject!=null ?this.subject.build():null;
  }
  public A withSubject(Reference subject) {
    _visitables.get("subject").remove(this.subject);
    if (subject!=null){ this.subject= new ReferenceBuilder(subject); _visitables.get("subject").add(this.subject);} else { this.subject = null; _visitables.get("subject").remove(this.subject); } return (A) this;
  }
  public Boolean hasSubject() {
    return this.subject != null;
  }
  public KafkaBindingSpecFluent.SubjectNested<A> withNewSubject() {
    return new KafkaBindingSpecFluentImpl.SubjectNestedImpl();
  }
  public KafkaBindingSpecFluent.SubjectNested<A> withNewSubjectLike(Reference item) {
    return new KafkaBindingSpecFluentImpl.SubjectNestedImpl(item);
  }
  public KafkaBindingSpecFluent.SubjectNested<A> editSubject() {
    return withNewSubjectLike(getSubject());
  }
  public KafkaBindingSpecFluent.SubjectNested<A> editOrNewSubject() {
    return withNewSubjectLike(getSubject() != null ? getSubject(): new ReferenceBuilder().build());
  }
  public KafkaBindingSpecFluent.SubjectNested<A> editOrNewSubjectLike(Reference item) {
    return withNewSubjectLike(getSubject() != null ? getSubject(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    KafkaBindingSpecFluentImpl that = (KafkaBindingSpecFluentImpl) o;
    if (bootstrapServers != null ? !bootstrapServers.equals(that.bootstrapServers) :that.bootstrapServers != null) return false;
    if (net != null ? !net.equals(that.net) :that.net != null) return false;
    if (subject != null ? !subject.equals(that.subject) :that.subject != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(bootstrapServers,  net,  subject,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (bootstrapServers != null && !bootstrapServers.isEmpty()) { sb.append("bootstrapServers:"); sb.append(bootstrapServers + ","); }
    if (net != null) { sb.append("net:"); sb.append(net + ","); }
    if (subject != null) { sb.append("subject:"); sb.append(subject); }
    sb.append("}");
    return sb.toString();
  }
  class NetNestedImpl<N> extends KafkaNetSpecFluentImpl<KafkaBindingSpecFluent.NetNested<N>> implements KafkaBindingSpecFluent.NetNested<N>,Nested<N>{
    NetNestedImpl(KafkaNetSpec item) {
      this.builder = new KafkaNetSpecBuilder(this, item);
    }
    NetNestedImpl() {
      this.builder = new KafkaNetSpecBuilder(this);
    }
    KafkaNetSpecBuilder builder;
    public N and() {
      return (N) KafkaBindingSpecFluentImpl.this.withNet(builder.build());
    }
    public N endNet() {
      return and();
    }
    
  }
  class SubjectNestedImpl<N> extends ReferenceFluentImpl<KafkaBindingSpecFluent.SubjectNested<N>> implements KafkaBindingSpecFluent.SubjectNested<N>,Nested<N>{
    SubjectNestedImpl(Reference item) {
      this.builder = new ReferenceBuilder(this, item);
    }
    SubjectNestedImpl() {
      this.builder = new ReferenceBuilder(this);
    }
    ReferenceBuilder builder;
    public N and() {
      return (N) KafkaBindingSpecFluentImpl.this.withSubject(builder.build());
    }
    public N endSubject() {
      return and();
    }
    
  }
  
}