package io.fabric8.knative.eventing.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SubscriptionsAPIFilterBuilder extends SubscriptionsAPIFilterFluentImpl<SubscriptionsAPIFilterBuilder> implements VisitableBuilder<SubscriptionsAPIFilter,SubscriptionsAPIFilterBuilder>{
  public SubscriptionsAPIFilterBuilder() {
    this(false);
  }
  public SubscriptionsAPIFilterBuilder(Boolean validationEnabled) {
    this(new SubscriptionsAPIFilter(), validationEnabled);
  }
  public SubscriptionsAPIFilterBuilder(SubscriptionsAPIFilterFluent<?> fluent) {
    this(fluent, false);
  }
  public SubscriptionsAPIFilterBuilder(SubscriptionsAPIFilterFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SubscriptionsAPIFilter(), validationEnabled);
  }
  public SubscriptionsAPIFilterBuilder(SubscriptionsAPIFilterFluent<?> fluent,SubscriptionsAPIFilter instance) {
    this(fluent, instance, false);
  }
  public SubscriptionsAPIFilterBuilder(SubscriptionsAPIFilterFluent<?> fluent,SubscriptionsAPIFilter instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAll(instance.getAll()); 
    fluent.withAny(instance.getAny()); 
    fluent.withCesql(instance.getCesql()); 
    fluent.withExact(instance.getExact()); 
    fluent.withNot(instance.getNot()); 
    fluent.withPrefix(instance.getPrefix()); 
    fluent.withSuffix(instance.getSuffix()); 
    this.validationEnabled = validationEnabled; 
  }
  public SubscriptionsAPIFilterBuilder(SubscriptionsAPIFilter instance) {
    this(instance,false);
  }
  public SubscriptionsAPIFilterBuilder(SubscriptionsAPIFilter instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAll(instance.getAll()); 
    this.withAny(instance.getAny()); 
    this.withCesql(instance.getCesql()); 
    this.withExact(instance.getExact()); 
    this.withNot(instance.getNot()); 
    this.withPrefix(instance.getPrefix()); 
    this.withSuffix(instance.getSuffix()); 
    this.validationEnabled = validationEnabled; 
  }
  SubscriptionsAPIFilterFluent<?> fluent;
  Boolean validationEnabled;
  public SubscriptionsAPIFilter build() {
    SubscriptionsAPIFilter buildable = new SubscriptionsAPIFilter(fluent.getAll(),fluent.getAny(),fluent.getCesql(),fluent.getExact(),fluent.getNot(),fluent.getPrefix(),fluent.getSuffix());
    return buildable;
  }
  
}