package io.fabric8.knative.eventing.contrib.awssqs.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AwsSqsSourceSpecBuilder extends AwsSqsSourceSpecFluentImpl<AwsSqsSourceSpecBuilder> implements VisitableBuilder<AwsSqsSourceSpec,AwsSqsSourceSpecBuilder>{
  public AwsSqsSourceSpecBuilder() {
    this(false);
  }
  public AwsSqsSourceSpecBuilder(Boolean validationEnabled) {
    this(new AwsSqsSourceSpec(), validationEnabled);
  }
  public AwsSqsSourceSpecBuilder(AwsSqsSourceSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public AwsSqsSourceSpecBuilder(AwsSqsSourceSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AwsSqsSourceSpec(), validationEnabled);
  }
  public AwsSqsSourceSpecBuilder(AwsSqsSourceSpecFluent<?> fluent,AwsSqsSourceSpec instance) {
    this(fluent, instance, false);
  }
  public AwsSqsSourceSpecBuilder(AwsSqsSourceSpecFluent<?> fluent,AwsSqsSourceSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withAwsCredsSecret(instance.getAwsCredsSecret());
      fluent.withQueueUrl(instance.getQueueUrl());
      fluent.withServiceAccountName(instance.getServiceAccountName());
      fluent.withSink(instance.getSink());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AwsSqsSourceSpecBuilder(AwsSqsSourceSpec instance) {
    this(instance,false);
  }
  public AwsSqsSourceSpecBuilder(AwsSqsSourceSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAnnotations(instance.getAnnotations());
      this.withAwsCredsSecret(instance.getAwsCredsSecret());
      this.withQueueUrl(instance.getQueueUrl());
      this.withServiceAccountName(instance.getServiceAccountName());
      this.withSink(instance.getSink());
    }
    this.validationEnabled = validationEnabled; 
  }
  AwsSqsSourceSpecFluent<?> fluent;
  Boolean validationEnabled;
  public AwsSqsSourceSpec build() {
    AwsSqsSourceSpec buildable = new AwsSqsSourceSpec(fluent.getAnnotations(),fluent.getAwsCredsSecret(),fluent.getQueueUrl(),fluent.getServiceAccountName(),fluent.getSink());
    return buildable;
  }
  
}