package io.fabric8.knative.eventing.contrib.couchdb.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CouchDbSourceBuilder extends CouchDbSourceFluentImpl<CouchDbSourceBuilder> implements VisitableBuilder<CouchDbSource,CouchDbSourceBuilder>{
  public CouchDbSourceBuilder() {
    this(false);
  }
  public CouchDbSourceBuilder(Boolean validationEnabled) {
    this(new CouchDbSource(), validationEnabled);
  }
  public CouchDbSourceBuilder(CouchDbSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public CouchDbSourceBuilder(CouchDbSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CouchDbSource(), validationEnabled);
  }
  public CouchDbSourceBuilder(CouchDbSourceFluent<?> fluent,CouchDbSource instance) {
    this(fluent, instance, false);
  }
  public CouchDbSourceBuilder(CouchDbSourceFluent<?> fluent,CouchDbSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CouchDbSourceBuilder(CouchDbSource instance) {
    this(instance,false);
  }
  public CouchDbSourceBuilder(CouchDbSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  CouchDbSourceFluent<?> fluent;
  Boolean validationEnabled;
  public CouchDbSource build() {
    CouchDbSource buildable = new CouchDbSource(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}