package io.fabric8.knative.eventing.contrib.couchdb.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CouchDbSourceSpecBuilder extends CouchDbSourceSpecFluentImpl<CouchDbSourceSpecBuilder> implements VisitableBuilder<CouchDbSourceSpec,CouchDbSourceSpecBuilder>{
  public CouchDbSourceSpecBuilder() {
    this(false);
  }
  public CouchDbSourceSpecBuilder(Boolean validationEnabled) {
    this(new CouchDbSourceSpec(), validationEnabled);
  }
  public CouchDbSourceSpecBuilder(CouchDbSourceSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public CouchDbSourceSpecBuilder(CouchDbSourceSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CouchDbSourceSpec(), validationEnabled);
  }
  public CouchDbSourceSpecBuilder(CouchDbSourceSpecFluent<?> fluent,CouchDbSourceSpec instance) {
    this(fluent, instance, false);
  }
  public CouchDbSourceSpecBuilder(CouchDbSourceSpecFluent<?> fluent,CouchDbSourceSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withCredentials(instance.getCredentials());
      fluent.withDatabase(instance.getDatabase());
      fluent.withFeed(instance.getFeed());
      fluent.withServiceAccountName(instance.getServiceAccountName());
      fluent.withSink(instance.getSink());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CouchDbSourceSpecBuilder(CouchDbSourceSpec instance) {
    this(instance,false);
  }
  public CouchDbSourceSpecBuilder(CouchDbSourceSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withCredentials(instance.getCredentials());
      this.withDatabase(instance.getDatabase());
      this.withFeed(instance.getFeed());
      this.withServiceAccountName(instance.getServiceAccountName());
      this.withSink(instance.getSink());
    }
    this.validationEnabled = validationEnabled; 
  }
  CouchDbSourceSpecFluent<?> fluent;
  Boolean validationEnabled;
  public CouchDbSourceSpec build() {
    CouchDbSourceSpec buildable = new CouchDbSourceSpec(fluent.getCredentials(),fluent.getDatabase(),fluent.getFeed(),fluent.getServiceAccountName(),fluent.getSink());
    return buildable;
  }
  
}