package io.fabric8.knative.eventing.contrib.couchdb.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CouchDbSourceStatusBuilder extends CouchDbSourceStatusFluentImpl<CouchDbSourceStatusBuilder> implements VisitableBuilder<CouchDbSourceStatus,CouchDbSourceStatusBuilder>{
  public CouchDbSourceStatusBuilder() {
    this(false);
  }
  public CouchDbSourceStatusBuilder(Boolean validationEnabled) {
    this(new CouchDbSourceStatus(), validationEnabled);
  }
  public CouchDbSourceStatusBuilder(CouchDbSourceStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public CouchDbSourceStatusBuilder(CouchDbSourceStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CouchDbSourceStatus(), validationEnabled);
  }
  public CouchDbSourceStatusBuilder(CouchDbSourceStatusFluent<?> fluent,CouchDbSourceStatus instance) {
    this(fluent, instance, false);
  }
  public CouchDbSourceStatusBuilder(CouchDbSourceStatusFluent<?> fluent,CouchDbSourceStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withCeAttributes(instance.getCeAttributes());
      fluent.withConditions(instance.getConditions());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withSinkUri(instance.getSinkUri());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CouchDbSourceStatusBuilder(CouchDbSourceStatus instance) {
    this(instance,false);
  }
  public CouchDbSourceStatusBuilder(CouchDbSourceStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAnnotations(instance.getAnnotations());
      this.withCeAttributes(instance.getCeAttributes());
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withSinkUri(instance.getSinkUri());
    }
    this.validationEnabled = validationEnabled; 
  }
  CouchDbSourceStatusFluent<?> fluent;
  Boolean validationEnabled;
  public CouchDbSourceStatus build() {
    CouchDbSourceStatus buildable = new CouchDbSourceStatus(fluent.getAnnotations(),fluent.getCeAttributes(),fluent.getConditions(),fluent.getObservedGeneration(),fluent.getSinkUri());
    return buildable;
  }
  
}