package io.fabric8.knative.eventing.contrib.github.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class GitHubBindingListFluentImpl<A extends GitHubBindingListFluent<A>> extends BaseFluent<A> implements GitHubBindingListFluent<A>{
  public GitHubBindingListFluentImpl() {
  }
  public GitHubBindingListFluentImpl(GitHubBindingList instance) {
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
  }
  private String apiVersion;
  private ArrayList<GitHubBindingBuilder> items = new ArrayList<GitHubBindingBuilder>();
  private String kind;
  private ListMeta metadata;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public A addToItems(int index,GitHubBinding item) {
    if (this.items == null) {this.items = new ArrayList<GitHubBindingBuilder>();}
    GitHubBindingBuilder builder = new GitHubBindingBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").add(index, builder); items.add(index, builder);}
    return (A)this;
  }
  public A setToItems(int index,GitHubBinding item) {
    if (this.items == null) {this.items = new ArrayList<GitHubBindingBuilder>();}
    GitHubBindingBuilder builder = new GitHubBindingBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").set(index, builder); items.set(index, builder);}
    return (A)this;
  }
  public A addToItems(io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubBinding... items) {
    if (this.items == null) {this.items = new ArrayList<GitHubBindingBuilder>();}
    for (GitHubBinding item : items) {GitHubBindingBuilder builder = new GitHubBindingBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToItems(Collection<GitHubBinding> items) {
    if (this.items == null) {this.items = new ArrayList<GitHubBindingBuilder>();}
    for (GitHubBinding item : items) {GitHubBindingBuilder builder = new GitHubBindingBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromItems(io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubBinding... items) {
    for (GitHubBinding item : items) {GitHubBindingBuilder builder = new GitHubBindingBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromItems(Collection<GitHubBinding> items) {
    for (GitHubBinding item : items) {GitHubBindingBuilder builder = new GitHubBindingBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromItems(Predicate<GitHubBindingBuilder> predicate) {
    if (items == null) return (A) this;
    final Iterator<GitHubBindingBuilder> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      GitHubBindingBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<GitHubBinding> getItems() {
    return items != null ? build(items) : null;
  }
  public List<GitHubBinding> buildItems() {
    return items != null ? build(items) : null;
  }
  public GitHubBinding buildItem(int index) {
    return this.items.get(index).build();
  }
  public GitHubBinding buildFirstItem() {
    return this.items.get(0).build();
  }
  public GitHubBinding buildLastItem() {
    return this.items.get(items.size() - 1).build();
  }
  public GitHubBinding buildMatchingItem(Predicate<GitHubBindingBuilder> predicate) {
    for (GitHubBindingBuilder item: items) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingItem(Predicate<GitHubBindingBuilder> predicate) {
    for (GitHubBindingBuilder item: items) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withItems(List<GitHubBinding> items) {
    if (this.items != null) { _visitables.get("items").clear();}
    if (items != null) {this.items = new ArrayList(); for (GitHubBinding item : items){this.addToItems(item);}} else { this.items = null;} return (A) this;
  }
  public A withItems(io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubBinding... items) {
    if (this.items != null) {this.items.clear(); _visitables.remove("items"); }
    if (items != null) {for (GitHubBinding item :items){ this.addToItems(item);}} return (A) this;
  }
  public Boolean hasItems() {
    return items != null && !items.isEmpty();
  }
  public GitHubBindingListFluentImpl.ItemsNested<A> addNewItem() {
    return new GitHubBindingListFluentImpl.ItemsNestedImpl();
  }
  public GitHubBindingListFluentImpl.ItemsNested<A> addNewItemLike(GitHubBinding item) {
    return new GitHubBindingListFluentImpl.ItemsNestedImpl(-1, item);
  }
  public GitHubBindingListFluentImpl.ItemsNested<A> setNewItemLike(int index,GitHubBinding item) {
    return new GitHubBindingListFluentImpl.ItemsNestedImpl(index, item);
  }
  public GitHubBindingListFluentImpl.ItemsNested<A> editItem(int index) {
    if (items.size() <= index) throw new RuntimeException("Can't edit items. Index exceeds size.");
    return setNewItemLike(index, buildItem(index));
  }
  public GitHubBindingListFluentImpl.ItemsNested<A> editFirstItem() {
    if (items.size() == 0) throw new RuntimeException("Can't edit first items. The list is empty.");
    return setNewItemLike(0, buildItem(0));
  }
  public GitHubBindingListFluentImpl.ItemsNested<A> editLastItem() {
    int index = items.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last items. The list is empty.");
    return setNewItemLike(index, buildItem(index));
  }
  public GitHubBindingListFluentImpl.ItemsNested<A> editMatchingItem(Predicate<GitHubBindingBuilder> predicate) {
    int index = -1;
    for (int i=0;i<items.size();i++) { 
    if (predicate.test(items.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching items. No match found.");
    return setNewItemLike(index, buildItem(index));
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  public ListMeta getMetadata() {
    return this.metadata;
  }
  public A withMetadata(ListMeta metadata) {
    this.metadata=metadata; return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink) {
    return (A)withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    GitHubBindingListFluentImpl that = (GitHubBindingListFluentImpl) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(items, that.items)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  items,  kind,  metadata,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (items != null) { sb.append("items:"); sb.append(items + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata); }
    sb.append("}");
    return sb.toString();
  }
  class ItemsNestedImpl<N> extends GitHubBindingFluentImpl<GitHubBindingListFluentImpl.ItemsNested<N>> implements GitHubBindingListFluentImpl.ItemsNested<N>,Nested<N>{
    ItemsNestedImpl(int index,GitHubBinding item) {
      this.index = index;
      this.builder = new GitHubBindingBuilder(this, item);
    }
    ItemsNestedImpl() {
      this.index = -1;
      this.builder = new GitHubBindingBuilder(this);
    }
    GitHubBindingBuilder builder;
    int index;
    public N and() {
      return (N) GitHubBindingListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endItem() {
      return and();
    }
    
  }
  
}