package io.fabric8.knative.eventing.contrib.github.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GitHubSourceBuilder extends GitHubSourceFluentImpl<GitHubSourceBuilder> implements VisitableBuilder<GitHubSource,GitHubSourceBuilder>{
  public GitHubSourceBuilder() {
    this(false);
  }
  public GitHubSourceBuilder(Boolean validationEnabled) {
    this(new GitHubSource(), validationEnabled);
  }
  public GitHubSourceBuilder(GitHubSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public GitHubSourceBuilder(GitHubSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GitHubSource(), validationEnabled);
  }
  public GitHubSourceBuilder(GitHubSourceFluent<?> fluent,GitHubSource instance) {
    this(fluent, instance, false);
  }
  public GitHubSourceBuilder(GitHubSourceFluent<?> fluent,GitHubSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GitHubSourceBuilder(GitHubSource instance) {
    this(instance,false);
  }
  public GitHubSourceBuilder(GitHubSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  GitHubSourceFluent<?> fluent;
  Boolean validationEnabled;
  public GitHubSource build() {
    GitHubSource buildable = new GitHubSource(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}