package io.fabric8.knative.eventing.contrib.github.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GitHubSourceListBuilder extends GitHubSourceListFluentImpl<GitHubSourceListBuilder> implements VisitableBuilder<GitHubSourceList,GitHubSourceListBuilder>{
  public GitHubSourceListBuilder() {
    this(false);
  }
  public GitHubSourceListBuilder(Boolean validationEnabled) {
    this(new GitHubSourceList(), validationEnabled);
  }
  public GitHubSourceListBuilder(GitHubSourceListFluent<?> fluent) {
    this(fluent, false);
  }
  public GitHubSourceListBuilder(GitHubSourceListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GitHubSourceList(), validationEnabled);
  }
  public GitHubSourceListBuilder(GitHubSourceListFluent<?> fluent,GitHubSourceList instance) {
    this(fluent, instance, false);
  }
  public GitHubSourceListBuilder(GitHubSourceListFluent<?> fluent,GitHubSourceList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GitHubSourceListBuilder(GitHubSourceList instance) {
    this(instance,false);
  }
  public GitHubSourceListBuilder(GitHubSourceList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  GitHubSourceListFluent<?> fluent;
  Boolean validationEnabled;
  public GitHubSourceList build() {
    GitHubSourceList buildable = new GitHubSourceList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}