package io.fabric8.knative.eventing.contrib.gitlab.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GitLabBindingSpecBuilder extends GitLabBindingSpecFluentImpl<GitLabBindingSpecBuilder> implements VisitableBuilder<GitLabBindingSpec,GitLabBindingSpecBuilder>{
  public GitLabBindingSpecBuilder() {
    this(false);
  }
  public GitLabBindingSpecBuilder(Boolean validationEnabled) {
    this(new GitLabBindingSpec(), validationEnabled);
  }
  public GitLabBindingSpecBuilder(GitLabBindingSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public GitLabBindingSpecBuilder(GitLabBindingSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GitLabBindingSpec(), validationEnabled);
  }
  public GitLabBindingSpecBuilder(GitLabBindingSpecFluent<?> fluent,GitLabBindingSpec instance) {
    this(fluent, instance, false);
  }
  public GitLabBindingSpecBuilder(GitLabBindingSpecFluent<?> fluent,GitLabBindingSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAccessToken(instance.getAccessToken());
      fluent.withSubject(instance.getSubject());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GitLabBindingSpecBuilder(GitLabBindingSpec instance) {
    this(instance,false);
  }
  public GitLabBindingSpecBuilder(GitLabBindingSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAccessToken(instance.getAccessToken());
      this.withSubject(instance.getSubject());
    }
    this.validationEnabled = validationEnabled; 
  }
  GitLabBindingSpecFluent<?> fluent;
  Boolean validationEnabled;
  public GitLabBindingSpec build() {
    GitLabBindingSpec buildable = new GitLabBindingSpec(fluent.getAccessToken(),fluent.getSubject());
    return buildable;
  }
  
}