package io.fabric8.knative.eventing.contrib.gitlab.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GitLabBindingStatusBuilder extends GitLabBindingStatusFluentImpl<GitLabBindingStatusBuilder> implements VisitableBuilder<GitLabBindingStatus,GitLabBindingStatusBuilder>{
  public GitLabBindingStatusBuilder() {
    this(false);
  }
  public GitLabBindingStatusBuilder(Boolean validationEnabled) {
    this(new GitLabBindingStatus(), validationEnabled);
  }
  public GitLabBindingStatusBuilder(GitLabBindingStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public GitLabBindingStatusBuilder(GitLabBindingStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GitLabBindingStatus(), validationEnabled);
  }
  public GitLabBindingStatusBuilder(GitLabBindingStatusFluent<?> fluent,GitLabBindingStatus instance) {
    this(fluent, instance, false);
  }
  public GitLabBindingStatusBuilder(GitLabBindingStatusFluent<?> fluent,GitLabBindingStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withCeAttributes(instance.getCeAttributes());
      fluent.withConditions(instance.getConditions());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withSinkUri(instance.getSinkUri());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GitLabBindingStatusBuilder(GitLabBindingStatus instance) {
    this(instance,false);
  }
  public GitLabBindingStatusBuilder(GitLabBindingStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAnnotations(instance.getAnnotations());
      this.withCeAttributes(instance.getCeAttributes());
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withSinkUri(instance.getSinkUri());
    }
    this.validationEnabled = validationEnabled; 
  }
  GitLabBindingStatusFluent<?> fluent;
  Boolean validationEnabled;
  public GitLabBindingStatus build() {
    GitLabBindingStatus buildable = new GitLabBindingStatus(fluent.getAnnotations(),fluent.getCeAttributes(),fluent.getConditions(),fluent.getObservedGeneration(),fluent.getSinkUri());
    return buildable;
  }
  
}