package io.fabric8.knative.eventing.contrib.gitlab.v1alpha1;

import io.fabric8.knative.internal.pkg.apis.duck.v1.Destination;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverrides;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverridesBuilder;
import java.lang.Boolean;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverridesFluentImpl;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationFluentImpl;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class GitLabSourceSpecFluentImpl<A extends GitLabSourceSpecFluent<A>> extends BaseFluent<A> implements GitLabSourceSpecFluent<A>{
  public GitLabSourceSpecFluentImpl() {
  }
  public GitLabSourceSpecFluentImpl(GitLabSourceSpec instance) {
    if (instance != null) {
      this.withAccessToken(instance.getAccessToken());
      this.withCeOverrides(instance.getCeOverrides());
      this.withEventTypes(instance.getEventTypes());
      this.withProjectUrl(instance.getProjectUrl());
      this.withSecretToken(instance.getSecretToken());
      this.withServiceAccountName(instance.getServiceAccountName());
      this.withSink(instance.getSink());
      this.withSslverify(instance.getSslverify());
    }
  }
  private SecretValueFromSourceBuilder accessToken;
  private CloudEventOverridesBuilder ceOverrides;
  private List<String> eventTypes = new ArrayList<String>();
  private String projectUrl;
  private SecretValueFromSourceBuilder secretToken;
  private String serviceAccountName;
  private DestinationBuilder sink;
  private Boolean sslverify;
  
  /**
   * This method has been deprecated, please use method buildAccessToken instead.
   * @return The buildable object.
   */
  @Deprecated
  public SecretValueFromSource getAccessToken() {
    return this.accessToken!=null ?this.accessToken.build():null;
  }
  public SecretValueFromSource buildAccessToken() {
    return this.accessToken!=null ?this.accessToken.build():null;
  }
  public A withAccessToken(SecretValueFromSource accessToken) {
    _visitables.get("accessToken").remove(this.accessToken);
    if (accessToken!=null){ this.accessToken= new SecretValueFromSourceBuilder(accessToken); _visitables.get("accessToken").add(this.accessToken);} else { this.accessToken = null; _visitables.get("accessToken").remove(this.accessToken); } return (A) this;
  }
  public Boolean hasAccessToken() {
    return this.accessToken != null;
  }
  public GitLabSourceSpecFluentImpl.AccessTokenNested<A> withNewAccessToken() {
    return new GitLabSourceSpecFluentImpl.AccessTokenNestedImpl();
  }
  public GitLabSourceSpecFluentImpl.AccessTokenNested<A> withNewAccessTokenLike(SecretValueFromSource item) {
    return new GitLabSourceSpecFluentImpl.AccessTokenNestedImpl(item);
  }
  public GitLabSourceSpecFluentImpl.AccessTokenNested<A> editAccessToken() {
    return withNewAccessTokenLike(getAccessToken());
  }
  public GitLabSourceSpecFluentImpl.AccessTokenNested<A> editOrNewAccessToken() {
    return withNewAccessTokenLike(getAccessToken() != null ? getAccessToken(): new SecretValueFromSourceBuilder().build());
  }
  public GitLabSourceSpecFluentImpl.AccessTokenNested<A> editOrNewAccessTokenLike(SecretValueFromSource item) {
    return withNewAccessTokenLike(getAccessToken() != null ? getAccessToken(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildCeOverrides instead.
   * @return The buildable object.
   */
  @Deprecated
  public CloudEventOverrides getCeOverrides() {
    return this.ceOverrides!=null ?this.ceOverrides.build():null;
  }
  public CloudEventOverrides buildCeOverrides() {
    return this.ceOverrides!=null ?this.ceOverrides.build():null;
  }
  public A withCeOverrides(CloudEventOverrides ceOverrides) {
    _visitables.get("ceOverrides").remove(this.ceOverrides);
    if (ceOverrides!=null){ this.ceOverrides= new CloudEventOverridesBuilder(ceOverrides); _visitables.get("ceOverrides").add(this.ceOverrides);} else { this.ceOverrides = null; _visitables.get("ceOverrides").remove(this.ceOverrides); } return (A) this;
  }
  public Boolean hasCeOverrides() {
    return this.ceOverrides != null;
  }
  public GitLabSourceSpecFluentImpl.CeOverridesNested<A> withNewCeOverrides() {
    return new GitLabSourceSpecFluentImpl.CeOverridesNestedImpl();
  }
  public GitLabSourceSpecFluentImpl.CeOverridesNested<A> withNewCeOverridesLike(CloudEventOverrides item) {
    return new GitLabSourceSpecFluentImpl.CeOverridesNestedImpl(item);
  }
  public GitLabSourceSpecFluentImpl.CeOverridesNested<A> editCeOverrides() {
    return withNewCeOverridesLike(getCeOverrides());
  }
  public GitLabSourceSpecFluentImpl.CeOverridesNested<A> editOrNewCeOverrides() {
    return withNewCeOverridesLike(getCeOverrides() != null ? getCeOverrides(): new CloudEventOverridesBuilder().build());
  }
  public GitLabSourceSpecFluentImpl.CeOverridesNested<A> editOrNewCeOverridesLike(CloudEventOverrides item) {
    return withNewCeOverridesLike(getCeOverrides() != null ? getCeOverrides(): item);
  }
  public A addToEventTypes(int index,String item) {
    if (this.eventTypes == null) {this.eventTypes = new ArrayList<String>();}
    this.eventTypes.add(index, item);
    return (A)this;
  }
  public A setToEventTypes(int index,String item) {
    if (this.eventTypes == null) {this.eventTypes = new ArrayList<String>();}
    this.eventTypes.set(index, item); return (A)this;
  }
  public A addToEventTypes(java.lang.String... items) {
    if (this.eventTypes == null) {this.eventTypes = new ArrayList<String>();}
    for (String item : items) {this.eventTypes.add(item);} return (A)this;
  }
  public A addAllToEventTypes(Collection<String> items) {
    if (this.eventTypes == null) {this.eventTypes = new ArrayList<String>();}
    for (String item : items) {this.eventTypes.add(item);} return (A)this;
  }
  public A removeFromEventTypes(java.lang.String... items) {
    for (String item : items) {if (this.eventTypes!= null){ this.eventTypes.remove(item);}} return (A)this;
  }
  public A removeAllFromEventTypes(Collection<String> items) {
    for (String item : items) {if (this.eventTypes!= null){ this.eventTypes.remove(item);}} return (A)this;
  }
  public List<String> getEventTypes() {
    return this.eventTypes;
  }
  public String getEventType(int index) {
    return this.eventTypes.get(index);
  }
  public String getFirstEventType() {
    return this.eventTypes.get(0);
  }
  public String getLastEventType() {
    return this.eventTypes.get(eventTypes.size() - 1);
  }
  public String getMatchingEventType(Predicate<String> predicate) {
    for (String item: eventTypes) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingEventType(Predicate<String> predicate) {
    for (String item: eventTypes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEventTypes(List<String> eventTypes) {
    if (eventTypes != null) {this.eventTypes = new ArrayList(); for (String item : eventTypes){this.addToEventTypes(item);}} else { this.eventTypes = null;} return (A) this;
  }
  public A withEventTypes(java.lang.String... eventTypes) {
    if (this.eventTypes != null) {this.eventTypes.clear(); _visitables.remove("eventTypes"); }
    if (eventTypes != null) {for (String item :eventTypes){ this.addToEventTypes(item);}} return (A) this;
  }
  public Boolean hasEventTypes() {
    return eventTypes != null && !eventTypes.isEmpty();
  }
  public String getProjectUrl() {
    return this.projectUrl;
  }
  public A withProjectUrl(String projectUrl) {
    this.projectUrl=projectUrl; return (A) this;
  }
  public Boolean hasProjectUrl() {
    return this.projectUrl != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSecretToken instead.
   * @return The buildable object.
   */
  @Deprecated
  public SecretValueFromSource getSecretToken() {
    return this.secretToken!=null ?this.secretToken.build():null;
  }
  public SecretValueFromSource buildSecretToken() {
    return this.secretToken!=null ?this.secretToken.build():null;
  }
  public A withSecretToken(SecretValueFromSource secretToken) {
    _visitables.get("secretToken").remove(this.secretToken);
    if (secretToken!=null){ this.secretToken= new SecretValueFromSourceBuilder(secretToken); _visitables.get("secretToken").add(this.secretToken);} else { this.secretToken = null; _visitables.get("secretToken").remove(this.secretToken); } return (A) this;
  }
  public Boolean hasSecretToken() {
    return this.secretToken != null;
  }
  public GitLabSourceSpecFluentImpl.SecretTokenNested<A> withNewSecretToken() {
    return new GitLabSourceSpecFluentImpl.SecretTokenNestedImpl();
  }
  public GitLabSourceSpecFluentImpl.SecretTokenNested<A> withNewSecretTokenLike(SecretValueFromSource item) {
    return new GitLabSourceSpecFluentImpl.SecretTokenNestedImpl(item);
  }
  public GitLabSourceSpecFluentImpl.SecretTokenNested<A> editSecretToken() {
    return withNewSecretTokenLike(getSecretToken());
  }
  public GitLabSourceSpecFluentImpl.SecretTokenNested<A> editOrNewSecretToken() {
    return withNewSecretTokenLike(getSecretToken() != null ? getSecretToken(): new SecretValueFromSourceBuilder().build());
  }
  public GitLabSourceSpecFluentImpl.SecretTokenNested<A> editOrNewSecretTokenLike(SecretValueFromSource item) {
    return withNewSecretTokenLike(getSecretToken() != null ? getSecretToken(): item);
  }
  public String getServiceAccountName() {
    return this.serviceAccountName;
  }
  public A withServiceAccountName(String serviceAccountName) {
    this.serviceAccountName=serviceAccountName; return (A) this;
  }
  public Boolean hasServiceAccountName() {
    return this.serviceAccountName != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSink instead.
   * @return The buildable object.
   */
  @Deprecated
  public Destination getSink() {
    return this.sink!=null ?this.sink.build():null;
  }
  public Destination buildSink() {
    return this.sink!=null ?this.sink.build():null;
  }
  public A withSink(Destination sink) {
    _visitables.get("sink").remove(this.sink);
    if (sink!=null){ this.sink= new DestinationBuilder(sink); _visitables.get("sink").add(this.sink);} else { this.sink = null; _visitables.get("sink").remove(this.sink); } return (A) this;
  }
  public Boolean hasSink() {
    return this.sink != null;
  }
  public GitLabSourceSpecFluentImpl.SinkNested<A> withNewSink() {
    return new GitLabSourceSpecFluentImpl.SinkNestedImpl();
  }
  public GitLabSourceSpecFluentImpl.SinkNested<A> withNewSinkLike(Destination item) {
    return new GitLabSourceSpecFluentImpl.SinkNestedImpl(item);
  }
  public GitLabSourceSpecFluentImpl.SinkNested<A> editSink() {
    return withNewSinkLike(getSink());
  }
  public GitLabSourceSpecFluentImpl.SinkNested<A> editOrNewSink() {
    return withNewSinkLike(getSink() != null ? getSink(): new DestinationBuilder().build());
  }
  public GitLabSourceSpecFluentImpl.SinkNested<A> editOrNewSinkLike(Destination item) {
    return withNewSinkLike(getSink() != null ? getSink(): item);
  }
  public Boolean getSslverify() {
    return this.sslverify;
  }
  public A withSslverify(Boolean sslverify) {
    this.sslverify=sslverify; return (A) this;
  }
  public Boolean hasSslverify() {
    return this.sslverify != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    GitLabSourceSpecFluentImpl that = (GitLabSourceSpecFluentImpl) o;
    if (!java.util.Objects.equals(accessToken, that.accessToken)) return false;

    if (!java.util.Objects.equals(ceOverrides, that.ceOverrides)) return false;

    if (!java.util.Objects.equals(eventTypes, that.eventTypes)) return false;

    if (!java.util.Objects.equals(projectUrl, that.projectUrl)) return false;

    if (!java.util.Objects.equals(secretToken, that.secretToken)) return false;

    if (!java.util.Objects.equals(serviceAccountName, that.serviceAccountName)) return false;

    if (!java.util.Objects.equals(sink, that.sink)) return false;

    if (!java.util.Objects.equals(sslverify, that.sslverify)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(accessToken,  ceOverrides,  eventTypes,  projectUrl,  secretToken,  serviceAccountName,  sink,  sslverify,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (accessToken != null) { sb.append("accessToken:"); sb.append(accessToken + ","); }
    if (ceOverrides != null) { sb.append("ceOverrides:"); sb.append(ceOverrides + ","); }
    if (eventTypes != null && !eventTypes.isEmpty()) { sb.append("eventTypes:"); sb.append(eventTypes + ","); }
    if (projectUrl != null) { sb.append("projectUrl:"); sb.append(projectUrl + ","); }
    if (secretToken != null) { sb.append("secretToken:"); sb.append(secretToken + ","); }
    if (serviceAccountName != null) { sb.append("serviceAccountName:"); sb.append(serviceAccountName + ","); }
    if (sink != null) { sb.append("sink:"); sb.append(sink + ","); }
    if (sslverify != null) { sb.append("sslverify:"); sb.append(sslverify); }
    sb.append("}");
    return sb.toString();
  }
  public A withSslverify() {
    return withSslverify(true);
  }
  class AccessTokenNestedImpl<N> extends SecretValueFromSourceFluentImpl<GitLabSourceSpecFluentImpl.AccessTokenNested<N>> implements GitLabSourceSpecFluentImpl.AccessTokenNested<N>,Nested<N>{
    AccessTokenNestedImpl(SecretValueFromSource item) {
      this.builder = new SecretValueFromSourceBuilder(this, item);
    }
    AccessTokenNestedImpl() {
      this.builder = new SecretValueFromSourceBuilder(this);
    }
    SecretValueFromSourceBuilder builder;
    public N and() {
      return (N) GitLabSourceSpecFluentImpl.this.withAccessToken(builder.build());
    }
    public N endAccessToken() {
      return and();
    }
    
  }
  class CeOverridesNestedImpl<N> extends CloudEventOverridesFluentImpl<GitLabSourceSpecFluentImpl.CeOverridesNested<N>> implements GitLabSourceSpecFluentImpl.CeOverridesNested<N>,Nested<N>{
    CeOverridesNestedImpl(CloudEventOverrides item) {
      this.builder = new CloudEventOverridesBuilder(this, item);
    }
    CeOverridesNestedImpl() {
      this.builder = new CloudEventOverridesBuilder(this);
    }
    CloudEventOverridesBuilder builder;
    public N and() {
      return (N) GitLabSourceSpecFluentImpl.this.withCeOverrides(builder.build());
    }
    public N endCeOverrides() {
      return and();
    }
    
  }
  class SecretTokenNestedImpl<N> extends SecretValueFromSourceFluentImpl<GitLabSourceSpecFluentImpl.SecretTokenNested<N>> implements GitLabSourceSpecFluentImpl.SecretTokenNested<N>,Nested<N>{
    SecretTokenNestedImpl(SecretValueFromSource item) {
      this.builder = new SecretValueFromSourceBuilder(this, item);
    }
    SecretTokenNestedImpl() {
      this.builder = new SecretValueFromSourceBuilder(this);
    }
    SecretValueFromSourceBuilder builder;
    public N and() {
      return (N) GitLabSourceSpecFluentImpl.this.withSecretToken(builder.build());
    }
    public N endSecretToken() {
      return and();
    }
    
  }
  class SinkNestedImpl<N> extends DestinationFluentImpl<GitLabSourceSpecFluentImpl.SinkNested<N>> implements GitLabSourceSpecFluentImpl.SinkNested<N>,Nested<N>{
    SinkNestedImpl(Destination item) {
      this.builder = new DestinationBuilder(this, item);
    }
    SinkNestedImpl() {
      this.builder = new DestinationBuilder(this);
    }
    DestinationBuilder builder;
    public N and() {
      return (N) GitLabSourceSpecFluentImpl.this.withSink(builder.build());
    }
    public N endSink() {
      return and();
    }
    
  }
  
}