package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class KafkaBindingFluentImpl<A extends KafkaBindingFluent<A>> extends BaseFluent<A> implements KafkaBindingFluent<A>{
  public KafkaBindingFluentImpl() {
  }
  public KafkaBindingFluentImpl(KafkaBinding instance) {
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
  }
  private String apiVersion;
  private String kind;
  private ObjectMetaBuilder metadata;
  private KafkaBindingSpecBuilder spec;
  private KafkaBindingStatusBuilder status;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public KafkaBindingFluentImpl.MetadataNested<A> withNewMetadata() {
    return new KafkaBindingFluentImpl.MetadataNestedImpl();
  }
  public KafkaBindingFluentImpl.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new KafkaBindingFluentImpl.MetadataNestedImpl(item);
  }
  public KafkaBindingFluentImpl.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public KafkaBindingFluentImpl.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public KafkaBindingFluentImpl.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public KafkaBindingSpec getSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public KafkaBindingSpec buildSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public A withSpec(KafkaBindingSpec spec) {
    _visitables.get("spec").remove(this.spec);
    if (spec!=null){ this.spec= new KafkaBindingSpecBuilder(spec); _visitables.get("spec").add(this.spec);} else { this.spec = null; _visitables.get("spec").remove(this.spec); } return (A) this;
  }
  public Boolean hasSpec() {
    return this.spec != null;
  }
  public KafkaBindingFluentImpl.SpecNested<A> withNewSpec() {
    return new KafkaBindingFluentImpl.SpecNestedImpl();
  }
  public KafkaBindingFluentImpl.SpecNested<A> withNewSpecLike(KafkaBindingSpec item) {
    return new KafkaBindingFluentImpl.SpecNestedImpl(item);
  }
  public KafkaBindingFluentImpl.SpecNested<A> editSpec() {
    return withNewSpecLike(getSpec());
  }
  public KafkaBindingFluentImpl.SpecNested<A> editOrNewSpec() {
    return withNewSpecLike(getSpec() != null ? getSpec(): new KafkaBindingSpecBuilder().build());
  }
  public KafkaBindingFluentImpl.SpecNested<A> editOrNewSpecLike(KafkaBindingSpec item) {
    return withNewSpecLike(getSpec() != null ? getSpec(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public KafkaBindingStatus getStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public KafkaBindingStatus buildStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public A withStatus(KafkaBindingStatus status) {
    _visitables.get("status").remove(this.status);
    if (status!=null){ this.status= new KafkaBindingStatusBuilder(status); _visitables.get("status").add(this.status);} else { this.status = null; _visitables.get("status").remove(this.status); } return (A) this;
  }
  public Boolean hasStatus() {
    return this.status != null;
  }
  public KafkaBindingFluentImpl.StatusNested<A> withNewStatus() {
    return new KafkaBindingFluentImpl.StatusNestedImpl();
  }
  public KafkaBindingFluentImpl.StatusNested<A> withNewStatusLike(KafkaBindingStatus item) {
    return new KafkaBindingFluentImpl.StatusNestedImpl(item);
  }
  public KafkaBindingFluentImpl.StatusNested<A> editStatus() {
    return withNewStatusLike(getStatus());
  }
  public KafkaBindingFluentImpl.StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(getStatus() != null ? getStatus(): new KafkaBindingStatusBuilder().build());
  }
  public KafkaBindingFluentImpl.StatusNested<A> editOrNewStatusLike(KafkaBindingStatus item) {
    return withNewStatusLike(getStatus() != null ? getStatus(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KafkaBindingFluentImpl that = (KafkaBindingFluentImpl) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    if (!java.util.Objects.equals(spec, that.spec)) return false;

    if (!java.util.Objects.equals(status, that.status)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  status,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (spec != null) { sb.append("spec:"); sb.append(spec + ","); }
    if (status != null) { sb.append("status:"); sb.append(status); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<KafkaBindingFluentImpl.MetadataNested<N>> implements KafkaBindingFluentImpl.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) KafkaBindingFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class SpecNestedImpl<N> extends KafkaBindingSpecFluentImpl<KafkaBindingFluentImpl.SpecNested<N>> implements KafkaBindingFluentImpl.SpecNested<N>,Nested<N>{
    SpecNestedImpl(KafkaBindingSpec item) {
      this.builder = new KafkaBindingSpecBuilder(this, item);
    }
    SpecNestedImpl() {
      this.builder = new KafkaBindingSpecBuilder(this);
    }
    KafkaBindingSpecBuilder builder;
    public N and() {
      return (N) KafkaBindingFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec() {
      return and();
    }
    
  }
  class StatusNestedImpl<N> extends KafkaBindingStatusFluentImpl<KafkaBindingFluentImpl.StatusNested<N>> implements KafkaBindingFluentImpl.StatusNested<N>,Nested<N>{
    StatusNestedImpl(KafkaBindingStatus item) {
      this.builder = new KafkaBindingStatusBuilder(this, item);
    }
    StatusNestedImpl() {
      this.builder = new KafkaBindingStatusBuilder(this);
    }
    KafkaBindingStatusBuilder builder;
    public N and() {
      return (N) KafkaBindingFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus() {
      return and();
    }
    
  }
  
}