package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaBindingSpecBuilder extends KafkaBindingSpecFluentImpl<KafkaBindingSpecBuilder> implements VisitableBuilder<KafkaBindingSpec,KafkaBindingSpecBuilder>{
  public KafkaBindingSpecBuilder() {
    this(false);
  }
  public KafkaBindingSpecBuilder(Boolean validationEnabled) {
    this(new KafkaBindingSpec(), validationEnabled);
  }
  public KafkaBindingSpecBuilder(KafkaBindingSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaBindingSpecBuilder(KafkaBindingSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaBindingSpec(), validationEnabled);
  }
  public KafkaBindingSpecBuilder(KafkaBindingSpecFluent<?> fluent,KafkaBindingSpec instance) {
    this(fluent, instance, false);
  }
  public KafkaBindingSpecBuilder(KafkaBindingSpecFluent<?> fluent,KafkaBindingSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withBootstrapServers(instance.getBootstrapServers());
      fluent.withNet(instance.getNet());
      fluent.withSubject(instance.getSubject());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaBindingSpecBuilder(KafkaBindingSpec instance) {
    this(instance,false);
  }
  public KafkaBindingSpecBuilder(KafkaBindingSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withBootstrapServers(instance.getBootstrapServers());
      this.withNet(instance.getNet());
      this.withSubject(instance.getSubject());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaBindingSpecFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaBindingSpec build() {
    KafkaBindingSpec buildable = new KafkaBindingSpec(fluent.getBootstrapServers(),fluent.getNet(),fluent.getSubject());
    return buildable;
  }
  
}