package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class KafkaChannelFluentImpl<A extends KafkaChannelFluent<A>> extends BaseFluent<A> implements KafkaChannelFluent<A>{
  public KafkaChannelFluentImpl() {
  }
  public KafkaChannelFluentImpl(KafkaChannel instance) {
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
  }
  private String apiVersion;
  private String kind;
  private ObjectMetaBuilder metadata;
  private KafkaChannelSpecBuilder spec;
  private KafkaChannelStatusBuilder status;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public KafkaChannelFluentImpl.MetadataNested<A> withNewMetadata() {
    return new KafkaChannelFluentImpl.MetadataNestedImpl();
  }
  public KafkaChannelFluentImpl.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new KafkaChannelFluentImpl.MetadataNestedImpl(item);
  }
  public KafkaChannelFluentImpl.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public KafkaChannelFluentImpl.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public KafkaChannelFluentImpl.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public KafkaChannelSpec getSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public KafkaChannelSpec buildSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public A withSpec(KafkaChannelSpec spec) {
    _visitables.get("spec").remove(this.spec);
    if (spec!=null){ this.spec= new KafkaChannelSpecBuilder(spec); _visitables.get("spec").add(this.spec);} else { this.spec = null; _visitables.get("spec").remove(this.spec); } return (A) this;
  }
  public Boolean hasSpec() {
    return this.spec != null;
  }
  public KafkaChannelFluentImpl.SpecNested<A> withNewSpec() {
    return new KafkaChannelFluentImpl.SpecNestedImpl();
  }
  public KafkaChannelFluentImpl.SpecNested<A> withNewSpecLike(KafkaChannelSpec item) {
    return new KafkaChannelFluentImpl.SpecNestedImpl(item);
  }
  public KafkaChannelFluentImpl.SpecNested<A> editSpec() {
    return withNewSpecLike(getSpec());
  }
  public KafkaChannelFluentImpl.SpecNested<A> editOrNewSpec() {
    return withNewSpecLike(getSpec() != null ? getSpec(): new KafkaChannelSpecBuilder().build());
  }
  public KafkaChannelFluentImpl.SpecNested<A> editOrNewSpecLike(KafkaChannelSpec item) {
    return withNewSpecLike(getSpec() != null ? getSpec(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public KafkaChannelStatus getStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public KafkaChannelStatus buildStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public A withStatus(KafkaChannelStatus status) {
    _visitables.get("status").remove(this.status);
    if (status!=null){ this.status= new KafkaChannelStatusBuilder(status); _visitables.get("status").add(this.status);} else { this.status = null; _visitables.get("status").remove(this.status); } return (A) this;
  }
  public Boolean hasStatus() {
    return this.status != null;
  }
  public KafkaChannelFluentImpl.StatusNested<A> withNewStatus() {
    return new KafkaChannelFluentImpl.StatusNestedImpl();
  }
  public KafkaChannelFluentImpl.StatusNested<A> withNewStatusLike(KafkaChannelStatus item) {
    return new KafkaChannelFluentImpl.StatusNestedImpl(item);
  }
  public KafkaChannelFluentImpl.StatusNested<A> editStatus() {
    return withNewStatusLike(getStatus());
  }
  public KafkaChannelFluentImpl.StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(getStatus() != null ? getStatus(): new KafkaChannelStatusBuilder().build());
  }
  public KafkaChannelFluentImpl.StatusNested<A> editOrNewStatusLike(KafkaChannelStatus item) {
    return withNewStatusLike(getStatus() != null ? getStatus(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KafkaChannelFluentImpl that = (KafkaChannelFluentImpl) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    if (!java.util.Objects.equals(spec, that.spec)) return false;

    if (!java.util.Objects.equals(status, that.status)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  status,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (spec != null) { sb.append("spec:"); sb.append(spec + ","); }
    if (status != null) { sb.append("status:"); sb.append(status); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<KafkaChannelFluentImpl.MetadataNested<N>> implements KafkaChannelFluentImpl.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) KafkaChannelFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class SpecNestedImpl<N> extends KafkaChannelSpecFluentImpl<KafkaChannelFluentImpl.SpecNested<N>> implements KafkaChannelFluentImpl.SpecNested<N>,Nested<N>{
    SpecNestedImpl(KafkaChannelSpec item) {
      this.builder = new KafkaChannelSpecBuilder(this, item);
    }
    SpecNestedImpl() {
      this.builder = new KafkaChannelSpecBuilder(this);
    }
    KafkaChannelSpecBuilder builder;
    public N and() {
      return (N) KafkaChannelFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec() {
      return and();
    }
    
  }
  class StatusNestedImpl<N> extends KafkaChannelStatusFluentImpl<KafkaChannelFluentImpl.StatusNested<N>> implements KafkaChannelFluentImpl.StatusNested<N>,Nested<N>{
    StatusNestedImpl(KafkaChannelStatus item) {
      this.builder = new KafkaChannelStatusBuilder(this, item);
    }
    StatusNestedImpl() {
      this.builder = new KafkaChannelStatusBuilder(this);
    }
    KafkaChannelStatusBuilder builder;
    public N and() {
      return (N) KafkaChannelFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus() {
      return and();
    }
    
  }
  
}