package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaSourceBuilder extends KafkaSourceFluentImpl<KafkaSourceBuilder> implements VisitableBuilder<KafkaSource,KafkaSourceBuilder>{
  public KafkaSourceBuilder() {
    this(false);
  }
  public KafkaSourceBuilder(Boolean validationEnabled) {
    this(new KafkaSource(), validationEnabled);
  }
  public KafkaSourceBuilder(KafkaSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaSourceBuilder(KafkaSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaSource(), validationEnabled);
  }
  public KafkaSourceBuilder(KafkaSourceFluent<?> fluent,KafkaSource instance) {
    this(fluent, instance, false);
  }
  public KafkaSourceBuilder(KafkaSourceFluent<?> fluent,KafkaSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaSourceBuilder(KafkaSource instance) {
    this(instance,false);
  }
  public KafkaSourceBuilder(KafkaSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaSourceFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaSource build() {
    KafkaSource buildable = new KafkaSource(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}