package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaSourceListBuilder extends KafkaSourceListFluentImpl<KafkaSourceListBuilder> implements VisitableBuilder<KafkaSourceList,KafkaSourceListBuilder>{
  public KafkaSourceListBuilder() {
    this(false);
  }
  public KafkaSourceListBuilder(Boolean validationEnabled) {
    this(new KafkaSourceList(), validationEnabled);
  }
  public KafkaSourceListBuilder(KafkaSourceListFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaSourceListBuilder(KafkaSourceListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaSourceList(), validationEnabled);
  }
  public KafkaSourceListBuilder(KafkaSourceListFluent<?> fluent,KafkaSourceList instance) {
    this(fluent, instance, false);
  }
  public KafkaSourceListBuilder(KafkaSourceListFluent<?> fluent,KafkaSourceList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaSourceListBuilder(KafkaSourceList instance) {
    this(instance,false);
  }
  public KafkaSourceListBuilder(KafkaSourceList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaSourceListFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaSourceList build() {
    KafkaSourceList buildable = new KafkaSourceList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}