package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.knative.internal.pkg.apis.duck.v1.Destination;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverrides;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverridesBuilder;
import java.lang.Boolean;
import java.lang.Integer;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverridesFluentImpl;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationFluentImpl;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class KafkaSourceSpecFluentImpl<A extends KafkaSourceSpecFluent<A>> extends BaseFluent<A> implements KafkaSourceSpecFluent<A>{
  public KafkaSourceSpecFluentImpl() {
  }
  public KafkaSourceSpecFluentImpl(KafkaSourceSpec instance) {
    if (instance != null) {
      this.withBootstrapServers(instance.getBootstrapServers());
      this.withCeOverrides(instance.getCeOverrides());
      this.withConsumerGroup(instance.getConsumerGroup());
      this.withConsumers(instance.getConsumers());
      this.withInitialOffset(instance.getInitialOffset());
      this.withNet(instance.getNet());
      this.withSink(instance.getSink());
      this.withTopics(instance.getTopics());
    }
  }
  private List<String> bootstrapServers = new ArrayList<String>();
  private CloudEventOverridesBuilder ceOverrides;
  private String consumerGroup;
  private Integer consumers;
  private String initialOffset;
  private KafkaNetSpecBuilder net;
  private DestinationBuilder sink;
  private List<String> topics = new ArrayList<String>();
  public A addToBootstrapServers(int index,String item) {
    if (this.bootstrapServers == null) {this.bootstrapServers = new ArrayList<String>();}
    this.bootstrapServers.add(index, item);
    return (A)this;
  }
  public A setToBootstrapServers(int index,String item) {
    if (this.bootstrapServers == null) {this.bootstrapServers = new ArrayList<String>();}
    this.bootstrapServers.set(index, item); return (A)this;
  }
  public A addToBootstrapServers(java.lang.String... items) {
    if (this.bootstrapServers == null) {this.bootstrapServers = new ArrayList<String>();}
    for (String item : items) {this.bootstrapServers.add(item);} return (A)this;
  }
  public A addAllToBootstrapServers(Collection<String> items) {
    if (this.bootstrapServers == null) {this.bootstrapServers = new ArrayList<String>();}
    for (String item : items) {this.bootstrapServers.add(item);} return (A)this;
  }
  public A removeFromBootstrapServers(java.lang.String... items) {
    for (String item : items) {if (this.bootstrapServers!= null){ this.bootstrapServers.remove(item);}} return (A)this;
  }
  public A removeAllFromBootstrapServers(Collection<String> items) {
    for (String item : items) {if (this.bootstrapServers!= null){ this.bootstrapServers.remove(item);}} return (A)this;
  }
  public List<String> getBootstrapServers() {
    return this.bootstrapServers;
  }
  public String getBootstrapServer(int index) {
    return this.bootstrapServers.get(index);
  }
  public String getFirstBootstrapServer() {
    return this.bootstrapServers.get(0);
  }
  public String getLastBootstrapServer() {
    return this.bootstrapServers.get(bootstrapServers.size() - 1);
  }
  public String getMatchingBootstrapServer(Predicate<String> predicate) {
    for (String item: bootstrapServers) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingBootstrapServer(Predicate<String> predicate) {
    for (String item: bootstrapServers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withBootstrapServers(List<String> bootstrapServers) {
    if (bootstrapServers != null) {this.bootstrapServers = new ArrayList(); for (String item : bootstrapServers){this.addToBootstrapServers(item);}} else { this.bootstrapServers = null;} return (A) this;
  }
  public A withBootstrapServers(java.lang.String... bootstrapServers) {
    if (this.bootstrapServers != null) {this.bootstrapServers.clear(); _visitables.remove("bootstrapServers"); }
    if (bootstrapServers != null) {for (String item :bootstrapServers){ this.addToBootstrapServers(item);}} return (A) this;
  }
  public Boolean hasBootstrapServers() {
    return bootstrapServers != null && !bootstrapServers.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildCeOverrides instead.
   * @return The buildable object.
   */
  @Deprecated
  public CloudEventOverrides getCeOverrides() {
    return this.ceOverrides!=null ?this.ceOverrides.build():null;
  }
  public CloudEventOverrides buildCeOverrides() {
    return this.ceOverrides!=null ?this.ceOverrides.build():null;
  }
  public A withCeOverrides(CloudEventOverrides ceOverrides) {
    _visitables.get("ceOverrides").remove(this.ceOverrides);
    if (ceOverrides!=null){ this.ceOverrides= new CloudEventOverridesBuilder(ceOverrides); _visitables.get("ceOverrides").add(this.ceOverrides);} else { this.ceOverrides = null; _visitables.get("ceOverrides").remove(this.ceOverrides); } return (A) this;
  }
  public Boolean hasCeOverrides() {
    return this.ceOverrides != null;
  }
  public KafkaSourceSpecFluentImpl.CeOverridesNested<A> withNewCeOverrides() {
    return new KafkaSourceSpecFluentImpl.CeOverridesNestedImpl();
  }
  public KafkaSourceSpecFluentImpl.CeOverridesNested<A> withNewCeOverridesLike(CloudEventOverrides item) {
    return new KafkaSourceSpecFluentImpl.CeOverridesNestedImpl(item);
  }
  public KafkaSourceSpecFluentImpl.CeOverridesNested<A> editCeOverrides() {
    return withNewCeOverridesLike(getCeOverrides());
  }
  public KafkaSourceSpecFluentImpl.CeOverridesNested<A> editOrNewCeOverrides() {
    return withNewCeOverridesLike(getCeOverrides() != null ? getCeOverrides(): new CloudEventOverridesBuilder().build());
  }
  public KafkaSourceSpecFluentImpl.CeOverridesNested<A> editOrNewCeOverridesLike(CloudEventOverrides item) {
    return withNewCeOverridesLike(getCeOverrides() != null ? getCeOverrides(): item);
  }
  public String getConsumerGroup() {
    return this.consumerGroup;
  }
  public A withConsumerGroup(String consumerGroup) {
    this.consumerGroup=consumerGroup; return (A) this;
  }
  public Boolean hasConsumerGroup() {
    return this.consumerGroup != null;
  }
  public Integer getConsumers() {
    return this.consumers;
  }
  public A withConsumers(Integer consumers) {
    this.consumers=consumers; return (A) this;
  }
  public Boolean hasConsumers() {
    return this.consumers != null;
  }
  public String getInitialOffset() {
    return this.initialOffset;
  }
  public A withInitialOffset(String initialOffset) {
    this.initialOffset=initialOffset; return (A) this;
  }
  public Boolean hasInitialOffset() {
    return this.initialOffset != null;
  }
  
  /**
   * This method has been deprecated, please use method buildNet instead.
   * @return The buildable object.
   */
  @Deprecated
  public KafkaNetSpec getNet() {
    return this.net!=null ?this.net.build():null;
  }
  public KafkaNetSpec buildNet() {
    return this.net!=null ?this.net.build():null;
  }
  public A withNet(KafkaNetSpec net) {
    _visitables.get("net").remove(this.net);
    if (net!=null){ this.net= new KafkaNetSpecBuilder(net); _visitables.get("net").add(this.net);} else { this.net = null; _visitables.get("net").remove(this.net); } return (A) this;
  }
  public Boolean hasNet() {
    return this.net != null;
  }
  public KafkaSourceSpecFluentImpl.NetNested<A> withNewNet() {
    return new KafkaSourceSpecFluentImpl.NetNestedImpl();
  }
  public KafkaSourceSpecFluentImpl.NetNested<A> withNewNetLike(KafkaNetSpec item) {
    return new KafkaSourceSpecFluentImpl.NetNestedImpl(item);
  }
  public KafkaSourceSpecFluentImpl.NetNested<A> editNet() {
    return withNewNetLike(getNet());
  }
  public KafkaSourceSpecFluentImpl.NetNested<A> editOrNewNet() {
    return withNewNetLike(getNet() != null ? getNet(): new KafkaNetSpecBuilder().build());
  }
  public KafkaSourceSpecFluentImpl.NetNested<A> editOrNewNetLike(KafkaNetSpec item) {
    return withNewNetLike(getNet() != null ? getNet(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSink instead.
   * @return The buildable object.
   */
  @Deprecated
  public Destination getSink() {
    return this.sink!=null ?this.sink.build():null;
  }
  public Destination buildSink() {
    return this.sink!=null ?this.sink.build():null;
  }
  public A withSink(Destination sink) {
    _visitables.get("sink").remove(this.sink);
    if (sink!=null){ this.sink= new DestinationBuilder(sink); _visitables.get("sink").add(this.sink);} else { this.sink = null; _visitables.get("sink").remove(this.sink); } return (A) this;
  }
  public Boolean hasSink() {
    return this.sink != null;
  }
  public KafkaSourceSpecFluentImpl.SinkNested<A> withNewSink() {
    return new KafkaSourceSpecFluentImpl.SinkNestedImpl();
  }
  public KafkaSourceSpecFluentImpl.SinkNested<A> withNewSinkLike(Destination item) {
    return new KafkaSourceSpecFluentImpl.SinkNestedImpl(item);
  }
  public KafkaSourceSpecFluentImpl.SinkNested<A> editSink() {
    return withNewSinkLike(getSink());
  }
  public KafkaSourceSpecFluentImpl.SinkNested<A> editOrNewSink() {
    return withNewSinkLike(getSink() != null ? getSink(): new DestinationBuilder().build());
  }
  public KafkaSourceSpecFluentImpl.SinkNested<A> editOrNewSinkLike(Destination item) {
    return withNewSinkLike(getSink() != null ? getSink(): item);
  }
  public A addToTopics(int index,String item) {
    if (this.topics == null) {this.topics = new ArrayList<String>();}
    this.topics.add(index, item);
    return (A)this;
  }
  public A setToTopics(int index,String item) {
    if (this.topics == null) {this.topics = new ArrayList<String>();}
    this.topics.set(index, item); return (A)this;
  }
  public A addToTopics(java.lang.String... items) {
    if (this.topics == null) {this.topics = new ArrayList<String>();}
    for (String item : items) {this.topics.add(item);} return (A)this;
  }
  public A addAllToTopics(Collection<String> items) {
    if (this.topics == null) {this.topics = new ArrayList<String>();}
    for (String item : items) {this.topics.add(item);} return (A)this;
  }
  public A removeFromTopics(java.lang.String... items) {
    for (String item : items) {if (this.topics!= null){ this.topics.remove(item);}} return (A)this;
  }
  public A removeAllFromTopics(Collection<String> items) {
    for (String item : items) {if (this.topics!= null){ this.topics.remove(item);}} return (A)this;
  }
  public List<String> getTopics() {
    return this.topics;
  }
  public String getTopic(int index) {
    return this.topics.get(index);
  }
  public String getFirstTopic() {
    return this.topics.get(0);
  }
  public String getLastTopic() {
    return this.topics.get(topics.size() - 1);
  }
  public String getMatchingTopic(Predicate<String> predicate) {
    for (String item: topics) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingTopic(Predicate<String> predicate) {
    for (String item: topics) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTopics(List<String> topics) {
    if (topics != null) {this.topics = new ArrayList(); for (String item : topics){this.addToTopics(item);}} else { this.topics = null;} return (A) this;
  }
  public A withTopics(java.lang.String... topics) {
    if (this.topics != null) {this.topics.clear(); _visitables.remove("topics"); }
    if (topics != null) {for (String item :topics){ this.addToTopics(item);}} return (A) this;
  }
  public Boolean hasTopics() {
    return topics != null && !topics.isEmpty();
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KafkaSourceSpecFluentImpl that = (KafkaSourceSpecFluentImpl) o;
    if (!java.util.Objects.equals(bootstrapServers, that.bootstrapServers)) return false;

    if (!java.util.Objects.equals(ceOverrides, that.ceOverrides)) return false;

    if (!java.util.Objects.equals(consumerGroup, that.consumerGroup)) return false;

    if (!java.util.Objects.equals(consumers, that.consumers)) return false;

    if (!java.util.Objects.equals(initialOffset, that.initialOffset)) return false;

    if (!java.util.Objects.equals(net, that.net)) return false;

    if (!java.util.Objects.equals(sink, that.sink)) return false;

    if (!java.util.Objects.equals(topics, that.topics)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(bootstrapServers,  ceOverrides,  consumerGroup,  consumers,  initialOffset,  net,  sink,  topics,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (bootstrapServers != null && !bootstrapServers.isEmpty()) { sb.append("bootstrapServers:"); sb.append(bootstrapServers + ","); }
    if (ceOverrides != null) { sb.append("ceOverrides:"); sb.append(ceOverrides + ","); }
    if (consumerGroup != null) { sb.append("consumerGroup:"); sb.append(consumerGroup + ","); }
    if (consumers != null) { sb.append("consumers:"); sb.append(consumers + ","); }
    if (initialOffset != null) { sb.append("initialOffset:"); sb.append(initialOffset + ","); }
    if (net != null) { sb.append("net:"); sb.append(net + ","); }
    if (sink != null) { sb.append("sink:"); sb.append(sink + ","); }
    if (topics != null && !topics.isEmpty()) { sb.append("topics:"); sb.append(topics); }
    sb.append("}");
    return sb.toString();
  }
  class CeOverridesNestedImpl<N> extends CloudEventOverridesFluentImpl<KafkaSourceSpecFluentImpl.CeOverridesNested<N>> implements KafkaSourceSpecFluentImpl.CeOverridesNested<N>,Nested<N>{
    CeOverridesNestedImpl(CloudEventOverrides item) {
      this.builder = new CloudEventOverridesBuilder(this, item);
    }
    CeOverridesNestedImpl() {
      this.builder = new CloudEventOverridesBuilder(this);
    }
    CloudEventOverridesBuilder builder;
    public N and() {
      return (N) KafkaSourceSpecFluentImpl.this.withCeOverrides(builder.build());
    }
    public N endCeOverrides() {
      return and();
    }
    
  }
  class NetNestedImpl<N> extends KafkaNetSpecFluentImpl<KafkaSourceSpecFluentImpl.NetNested<N>> implements KafkaSourceSpecFluentImpl.NetNested<N>,Nested<N>{
    NetNestedImpl(KafkaNetSpec item) {
      this.builder = new KafkaNetSpecBuilder(this, item);
    }
    NetNestedImpl() {
      this.builder = new KafkaNetSpecBuilder(this);
    }
    KafkaNetSpecBuilder builder;
    public N and() {
      return (N) KafkaSourceSpecFluentImpl.this.withNet(builder.build());
    }
    public N endNet() {
      return and();
    }
    
  }
  class SinkNestedImpl<N> extends DestinationFluentImpl<KafkaSourceSpecFluentImpl.SinkNested<N>> implements KafkaSourceSpecFluentImpl.SinkNested<N>,Nested<N>{
    SinkNestedImpl(Destination item) {
      this.builder = new DestinationBuilder(this, item);
    }
    SinkNestedImpl() {
      this.builder = new DestinationBuilder(this);
    }
    DestinationBuilder builder;
    public N and() {
      return (N) KafkaSourceSpecFluentImpl.this.withSink(builder.build());
    }
    public N endSink() {
      return and();
    }
    
  }
  
}