package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventAttributesBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventAttributesFluent;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1alpha1.Placement;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventAttributes;
import java.lang.Boolean;
import io.fabric8.knative.internal.pkg.apis.Condition;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1alpha1.PlacementBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1alpha1.PlacementFluent;
import io.fabric8.knative.internal.pkg.apis.ConditionFluent;
import java.lang.Integer;
import io.fabric8.knative.internal.pkg.apis.ConditionBuilder;
import java.lang.Long;
import java.util.Collection;
import java.util.Map;

 /**
  * Generated
  */
public interface KafkaSourceStatusFluent<A extends KafkaSourceStatusFluent<A>> extends Fluent<A>{
  public A addToAnnotations(String key,String value);
  public A addToAnnotations(Map<String,String> map);
  public A removeFromAnnotations(String key);
  public A removeFromAnnotations(Map<String,String> map);
  public Map<String,String> getAnnotations();
  public <K,V>A withAnnotations(Map<String,String> annotations);
  public Boolean hasAnnotations();
  public A addToCeAttributes(int index,CloudEventAttributes item);
  public A setToCeAttributes(int index,CloudEventAttributes item);
  public A addToCeAttributes(io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventAttributes... items);
  public A addAllToCeAttributes(Collection<CloudEventAttributes> items);
  public A removeFromCeAttributes(io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventAttributes... items);
  public A removeAllFromCeAttributes(Collection<CloudEventAttributes> items);
  public A removeMatchingFromCeAttributes(Predicate<CloudEventAttributesBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildCeAttributes instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<CloudEventAttributes> getCeAttributes();
  public List<CloudEventAttributes> buildCeAttributes();
  public CloudEventAttributes buildCeAttribute(int index);
  public CloudEventAttributes buildFirstCeAttribute();
  public CloudEventAttributes buildLastCeAttribute();
  public CloudEventAttributes buildMatchingCeAttribute(Predicate<CloudEventAttributesBuilder> predicate);
  public Boolean hasMatchingCeAttribute(Predicate<CloudEventAttributesBuilder> predicate);
  public A withCeAttributes(List<CloudEventAttributes> ceAttributes);
  public A withCeAttributes(io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventAttributes... ceAttributes);
  public Boolean hasCeAttributes();
  public A addNewCeAttribute(String source,String type);
  public KafkaSourceStatusFluent.CeAttributesNested<A> addNewCeAttribute();
  public KafkaSourceStatusFluent.CeAttributesNested<A> addNewCeAttributeLike(CloudEventAttributes item);
  public KafkaSourceStatusFluent.CeAttributesNested<A> setNewCeAttributeLike(int index,CloudEventAttributes item);
  public KafkaSourceStatusFluent.CeAttributesNested<A> editCeAttribute(int index);
  public KafkaSourceStatusFluent.CeAttributesNested<A> editFirstCeAttribute();
  public KafkaSourceStatusFluent.CeAttributesNested<A> editLastCeAttribute();
  public KafkaSourceStatusFluent.CeAttributesNested<A> editMatchingCeAttribute(Predicate<CloudEventAttributesBuilder> predicate);
  public String getClaims();
  public A withClaims(String claims);
  public Boolean hasClaims();
  public A addToConditions(int index,Condition item);
  public A setToConditions(int index,Condition item);
  public A addToConditions(io.fabric8.knative.internal.pkg.apis.Condition... items);
  public A addAllToConditions(Collection<Condition> items);
  public A removeFromConditions(io.fabric8.knative.internal.pkg.apis.Condition... items);
  public A removeAllFromConditions(Collection<Condition> items);
  public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Condition> getConditions();
  public List<Condition> buildConditions();
  public Condition buildCondition(int index);
  public Condition buildFirstCondition();
  public Condition buildLastCondition();
  public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate);
  public Boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate);
  public A withConditions(List<Condition> conditions);
  public A withConditions(io.fabric8.knative.internal.pkg.apis.Condition... conditions);
  public Boolean hasConditions();
  public KafkaSourceStatusFluent.ConditionsNested<A> addNewCondition();
  public KafkaSourceStatusFluent.ConditionsNested<A> addNewConditionLike(Condition item);
  public KafkaSourceStatusFluent.ConditionsNested<A> setNewConditionLike(int index,Condition item);
  public KafkaSourceStatusFluent.ConditionsNested<A> editCondition(int index);
  public KafkaSourceStatusFluent.ConditionsNested<A> editFirstCondition();
  public KafkaSourceStatusFluent.ConditionsNested<A> editLastCondition();
  public KafkaSourceStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate);
  public Integer getConsumers();
  public A withConsumers(Integer consumers);
  public Boolean hasConsumers();
  public Integer getMaxAllowedVReplicas();
  public A withMaxAllowedVReplicas(Integer maxAllowedVReplicas);
  public Boolean hasMaxAllowedVReplicas();
  public Long getObservedGeneration();
  public A withObservedGeneration(Long observedGeneration);
  public Boolean hasObservedGeneration();
  public A addToPlacements(int index,Placement item);
  public A setToPlacements(int index,Placement item);
  public A addToPlacements(io.fabric8.knative.internal.eventing.pkg.apis.duck.v1alpha1.Placement... items);
  public A addAllToPlacements(Collection<Placement> items);
  public A removeFromPlacements(io.fabric8.knative.internal.eventing.pkg.apis.duck.v1alpha1.Placement... items);
  public A removeAllFromPlacements(Collection<Placement> items);
  public A removeMatchingFromPlacements(Predicate<PlacementBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildPlacements instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Placement> getPlacements();
  public List<Placement> buildPlacements();
  public Placement buildPlacement(int index);
  public Placement buildFirstPlacement();
  public Placement buildLastPlacement();
  public Placement buildMatchingPlacement(Predicate<PlacementBuilder> predicate);
  public Boolean hasMatchingPlacement(Predicate<PlacementBuilder> predicate);
  public A withPlacements(List<Placement> placements);
  public A withPlacements(io.fabric8.knative.internal.eventing.pkg.apis.duck.v1alpha1.Placement... placements);
  public Boolean hasPlacements();
  public A addNewPlacement(String podName,Integer vreplicas);
  public KafkaSourceStatusFluent.PlacementsNested<A> addNewPlacement();
  public KafkaSourceStatusFluent.PlacementsNested<A> addNewPlacementLike(Placement item);
  public KafkaSourceStatusFluent.PlacementsNested<A> setNewPlacementLike(int index,Placement item);
  public KafkaSourceStatusFluent.PlacementsNested<A> editPlacement(int index);
  public KafkaSourceStatusFluent.PlacementsNested<A> editFirstPlacement();
  public KafkaSourceStatusFluent.PlacementsNested<A> editLastPlacement();
  public KafkaSourceStatusFluent.PlacementsNested<A> editMatchingPlacement(Predicate<PlacementBuilder> predicate);
  public String getSelector();
  public A withSelector(String selector);
  public Boolean hasSelector();
  public String getSinkUri();
  public A withSinkUri(String sinkUri);
  public Boolean hasSinkUri();
  public interface CeAttributesNested<N> extends Nested<N>,CloudEventAttributesFluent<KafkaSourceStatusFluent.CeAttributesNested<N>>{
    public N and();
    public N endCeAttribute();
    
  }
  public interface ConditionsNested<N> extends Nested<N>,ConditionFluent<KafkaSourceStatusFluent.ConditionsNested<N>>{
    public N and();
    public N endCondition();
    
  }
  public interface PlacementsNested<N> extends Nested<N>,PlacementFluent<KafkaSourceStatusFluent.PlacementsNested<N>>{
    public N and();
    public N endPlacement();
    
  }
  
}