package io.fabric8.knative.eventing.contrib.prometheus.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PrometheusSourceBuilder extends PrometheusSourceFluentImpl<PrometheusSourceBuilder> implements VisitableBuilder<PrometheusSource,PrometheusSourceBuilder>{
  public PrometheusSourceBuilder() {
    this(false);
  }
  public PrometheusSourceBuilder(Boolean validationEnabled) {
    this(new PrometheusSource(), validationEnabled);
  }
  public PrometheusSourceBuilder(PrometheusSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public PrometheusSourceBuilder(PrometheusSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PrometheusSource(), validationEnabled);
  }
  public PrometheusSourceBuilder(PrometheusSourceFluent<?> fluent,PrometheusSource instance) {
    this(fluent, instance, false);
  }
  public PrometheusSourceBuilder(PrometheusSourceFluent<?> fluent,PrometheusSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PrometheusSourceBuilder(PrometheusSource instance) {
    this(instance,false);
  }
  public PrometheusSourceBuilder(PrometheusSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  PrometheusSourceFluent<?> fluent;
  Boolean validationEnabled;
  public PrometheusSource build() {
    PrometheusSource buildable = new PrometheusSource(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}