package io.fabric8.knative.eventing.contrib.prometheus.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PrometheusSourceSpecBuilder extends PrometheusSourceSpecFluentImpl<PrometheusSourceSpecBuilder> implements VisitableBuilder<PrometheusSourceSpec,PrometheusSourceSpecBuilder>{
  public PrometheusSourceSpecBuilder() {
    this(false);
  }
  public PrometheusSourceSpecBuilder(Boolean validationEnabled) {
    this(new PrometheusSourceSpec(), validationEnabled);
  }
  public PrometheusSourceSpecBuilder(PrometheusSourceSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public PrometheusSourceSpecBuilder(PrometheusSourceSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PrometheusSourceSpec(), validationEnabled);
  }
  public PrometheusSourceSpecBuilder(PrometheusSourceSpecFluent<?> fluent,PrometheusSourceSpec instance) {
    this(fluent, instance, false);
  }
  public PrometheusSourceSpecBuilder(PrometheusSourceSpecFluent<?> fluent,PrometheusSourceSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAuthTokenFile(instance.getAuthTokenFile());
      fluent.withCaCertConfigMap(instance.getCaCertConfigMap());
      fluent.withPromQL(instance.getPromQL());
      fluent.withSchedule(instance.getSchedule());
      fluent.withServerURL(instance.getServerURL());
      fluent.withServiceAccountName(instance.getServiceAccountName());
      fluent.withSink(instance.getSink());
      fluent.withStep(instance.getStep());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PrometheusSourceSpecBuilder(PrometheusSourceSpec instance) {
    this(instance,false);
  }
  public PrometheusSourceSpecBuilder(PrometheusSourceSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAuthTokenFile(instance.getAuthTokenFile());
      this.withCaCertConfigMap(instance.getCaCertConfigMap());
      this.withPromQL(instance.getPromQL());
      this.withSchedule(instance.getSchedule());
      this.withServerURL(instance.getServerURL());
      this.withServiceAccountName(instance.getServiceAccountName());
      this.withSink(instance.getSink());
      this.withStep(instance.getStep());
    }
    this.validationEnabled = validationEnabled; 
  }
  PrometheusSourceSpecFluent<?> fluent;
  Boolean validationEnabled;
  public PrometheusSourceSpec build() {
    PrometheusSourceSpec buildable = new PrometheusSourceSpec(fluent.getAuthTokenFile(),fluent.getCaCertConfigMap(),fluent.getPromQL(),fluent.getSchedule(),fluent.getServerURL(),fluent.getServiceAccountName(),fluent.getSink(),fluent.getStep());
    return buildable;
  }
  
}