package io.fabric8.knative.eventing.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BrokerSpecBuilder extends BrokerSpecFluentImpl<BrokerSpecBuilder> implements VisitableBuilder<BrokerSpec,BrokerSpecBuilder>{
  public BrokerSpecBuilder() {
    this(false);
  }
  public BrokerSpecBuilder(Boolean validationEnabled) {
    this(new BrokerSpec(), validationEnabled);
  }
  public BrokerSpecBuilder(BrokerSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public BrokerSpecBuilder(BrokerSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BrokerSpec(), validationEnabled);
  }
  public BrokerSpecBuilder(BrokerSpecFluent<?> fluent,BrokerSpec instance) {
    this(fluent, instance, false);
  }
  public BrokerSpecBuilder(BrokerSpecFluent<?> fluent,BrokerSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withConfig(instance.getConfig());
      fluent.withDelivery(instance.getDelivery());
    }
    this.validationEnabled = validationEnabled; 
  }
  public BrokerSpecBuilder(BrokerSpec instance) {
    this(instance,false);
  }
  public BrokerSpecBuilder(BrokerSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withConfig(instance.getConfig());
      this.withDelivery(instance.getDelivery());
    }
    this.validationEnabled = validationEnabled; 
  }
  BrokerSpecFluent<?> fluent;
  Boolean validationEnabled;
  public BrokerSpec build() {
    BrokerSpec buildable = new BrokerSpec(fluent.getConfig(),fluent.getDelivery());
    return buildable;
  }
  
}