package io.fabric8.knative.eventing.v1;

import io.fabric8.knative.internal.pkg.apis.duck.v1.Destination;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpecFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpec;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpecBuilder;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationFluentImpl;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class TriggerSpecFluentImpl<A extends TriggerSpecFluent<A>> extends BaseFluent<A> implements TriggerSpecFluent<A>{
  public TriggerSpecFluentImpl() {
  }
  public TriggerSpecFluentImpl(TriggerSpec instance) {
    if (instance != null) {
      this.withBroker(instance.getBroker());
      this.withDelivery(instance.getDelivery());
      this.withFilter(instance.getFilter());
      this.withFilters(instance.getFilters());
      this.withSubscriber(instance.getSubscriber());
    }
  }
  private String broker;
  private DeliverySpecBuilder delivery;
  private TriggerFilterBuilder filter;
  private ArrayList<SubscriptionsAPIFilterBuilder> filters = new ArrayList<SubscriptionsAPIFilterBuilder>();
  private DestinationBuilder subscriber;
  public String getBroker() {
    return this.broker;
  }
  public A withBroker(String broker) {
    this.broker=broker; return (A) this;
  }
  public Boolean hasBroker() {
    return this.broker != null;
  }
  
  /**
   * This method has been deprecated, please use method buildDelivery instead.
   * @return The buildable object.
   */
  @Deprecated
  public DeliverySpec getDelivery() {
    return this.delivery!=null ?this.delivery.build():null;
  }
  public DeliverySpec buildDelivery() {
    return this.delivery!=null ?this.delivery.build():null;
  }
  public A withDelivery(DeliverySpec delivery) {
    _visitables.get("delivery").remove(this.delivery);
    if (delivery!=null){ this.delivery= new DeliverySpecBuilder(delivery); _visitables.get("delivery").add(this.delivery);} else { this.delivery = null; _visitables.get("delivery").remove(this.delivery); } return (A) this;
  }
  public Boolean hasDelivery() {
    return this.delivery != null;
  }
  public TriggerSpecFluentImpl.DeliveryNested<A> withNewDelivery() {
    return new TriggerSpecFluentImpl.DeliveryNestedImpl();
  }
  public TriggerSpecFluentImpl.DeliveryNested<A> withNewDeliveryLike(DeliverySpec item) {
    return new TriggerSpecFluentImpl.DeliveryNestedImpl(item);
  }
  public TriggerSpecFluentImpl.DeliveryNested<A> editDelivery() {
    return withNewDeliveryLike(getDelivery());
  }
  public TriggerSpecFluentImpl.DeliveryNested<A> editOrNewDelivery() {
    return withNewDeliveryLike(getDelivery() != null ? getDelivery(): new DeliverySpecBuilder().build());
  }
  public TriggerSpecFluentImpl.DeliveryNested<A> editOrNewDeliveryLike(DeliverySpec item) {
    return withNewDeliveryLike(getDelivery() != null ? getDelivery(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildFilter instead.
   * @return The buildable object.
   */
  @Deprecated
  public TriggerFilter getFilter() {
    return this.filter!=null ?this.filter.build():null;
  }
  public TriggerFilter buildFilter() {
    return this.filter!=null ?this.filter.build():null;
  }
  public A withFilter(TriggerFilter filter) {
    _visitables.get("filter").remove(this.filter);
    if (filter!=null){ this.filter= new TriggerFilterBuilder(filter); _visitables.get("filter").add(this.filter);} else { this.filter = null; _visitables.get("filter").remove(this.filter); } return (A) this;
  }
  public Boolean hasFilter() {
    return this.filter != null;
  }
  public TriggerSpecFluentImpl.FilterNested<A> withNewFilter() {
    return new TriggerSpecFluentImpl.FilterNestedImpl();
  }
  public TriggerSpecFluentImpl.FilterNested<A> withNewFilterLike(TriggerFilter item) {
    return new TriggerSpecFluentImpl.FilterNestedImpl(item);
  }
  public TriggerSpecFluentImpl.FilterNested<A> editFilter() {
    return withNewFilterLike(getFilter());
  }
  public TriggerSpecFluentImpl.FilterNested<A> editOrNewFilter() {
    return withNewFilterLike(getFilter() != null ? getFilter(): new TriggerFilterBuilder().build());
  }
  public TriggerSpecFluentImpl.FilterNested<A> editOrNewFilterLike(TriggerFilter item) {
    return withNewFilterLike(getFilter() != null ? getFilter(): item);
  }
  public A addToFilters(int index,SubscriptionsAPIFilter item) {
    if (this.filters == null) {this.filters = new ArrayList<SubscriptionsAPIFilterBuilder>();}
    SubscriptionsAPIFilterBuilder builder = new SubscriptionsAPIFilterBuilder(item);
    if (index < 0 || index >= filters.size()) { _visitables.get("filters").add(builder); filters.add(builder); } else { _visitables.get("filters").add(index, builder); filters.add(index, builder);}
    return (A)this;
  }
  public A setToFilters(int index,SubscriptionsAPIFilter item) {
    if (this.filters == null) {this.filters = new ArrayList<SubscriptionsAPIFilterBuilder>();}
    SubscriptionsAPIFilterBuilder builder = new SubscriptionsAPIFilterBuilder(item);
    if (index < 0 || index >= filters.size()) { _visitables.get("filters").add(builder); filters.add(builder); } else { _visitables.get("filters").set(index, builder); filters.set(index, builder);}
    return (A)this;
  }
  public A addToFilters(io.fabric8.knative.eventing.v1.SubscriptionsAPIFilter... items) {
    if (this.filters == null) {this.filters = new ArrayList<SubscriptionsAPIFilterBuilder>();}
    for (SubscriptionsAPIFilter item : items) {SubscriptionsAPIFilterBuilder builder = new SubscriptionsAPIFilterBuilder(item);_visitables.get("filters").add(builder);this.filters.add(builder);} return (A)this;
  }
  public A addAllToFilters(Collection<SubscriptionsAPIFilter> items) {
    if (this.filters == null) {this.filters = new ArrayList<SubscriptionsAPIFilterBuilder>();}
    for (SubscriptionsAPIFilter item : items) {SubscriptionsAPIFilterBuilder builder = new SubscriptionsAPIFilterBuilder(item);_visitables.get("filters").add(builder);this.filters.add(builder);} return (A)this;
  }
  public A removeFromFilters(io.fabric8.knative.eventing.v1.SubscriptionsAPIFilter... items) {
    for (SubscriptionsAPIFilter item : items) {SubscriptionsAPIFilterBuilder builder = new SubscriptionsAPIFilterBuilder(item);_visitables.get("filters").remove(builder);if (this.filters != null) {this.filters.remove(builder);}} return (A)this;
  }
  public A removeAllFromFilters(Collection<SubscriptionsAPIFilter> items) {
    for (SubscriptionsAPIFilter item : items) {SubscriptionsAPIFilterBuilder builder = new SubscriptionsAPIFilterBuilder(item);_visitables.get("filters").remove(builder);if (this.filters != null) {this.filters.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromFilters(Predicate<SubscriptionsAPIFilterBuilder> predicate) {
    if (filters == null) return (A) this;
    final Iterator<SubscriptionsAPIFilterBuilder> each = filters.iterator();
    final List visitables = _visitables.get("filters");
    while (each.hasNext()) {
      SubscriptionsAPIFilterBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildFilters instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<SubscriptionsAPIFilter> getFilters() {
    return filters != null ? build(filters) : null;
  }
  public List<SubscriptionsAPIFilter> buildFilters() {
    return filters != null ? build(filters) : null;
  }
  public SubscriptionsAPIFilter buildFilter(int index) {
    return this.filters.get(index).build();
  }
  public SubscriptionsAPIFilter buildFirstFilter() {
    return this.filters.get(0).build();
  }
  public SubscriptionsAPIFilter buildLastFilter() {
    return this.filters.get(filters.size() - 1).build();
  }
  public SubscriptionsAPIFilter buildMatchingFilter(Predicate<SubscriptionsAPIFilterBuilder> predicate) {
    for (SubscriptionsAPIFilterBuilder item: filters) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingFilter(Predicate<SubscriptionsAPIFilterBuilder> predicate) {
    for (SubscriptionsAPIFilterBuilder item: filters) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withFilters(List<SubscriptionsAPIFilter> filters) {
    if (this.filters != null) { _visitables.get("filters").clear();}
    if (filters != null) {this.filters = new ArrayList(); for (SubscriptionsAPIFilter item : filters){this.addToFilters(item);}} else { this.filters = null;} return (A) this;
  }
  public A withFilters(io.fabric8.knative.eventing.v1.SubscriptionsAPIFilter... filters) {
    if (this.filters != null) {this.filters.clear(); _visitables.remove("filters"); }
    if (filters != null) {for (SubscriptionsAPIFilter item :filters){ this.addToFilters(item);}} return (A) this;
  }
  public Boolean hasFilters() {
    return filters != null && !filters.isEmpty();
  }
  public TriggerSpecFluentImpl.FiltersNested<A> addNewFilter() {
    return new TriggerSpecFluentImpl.FiltersNestedImpl();
  }
  public TriggerSpecFluentImpl.FiltersNested<A> addNewFilterLike(SubscriptionsAPIFilter item) {
    return new TriggerSpecFluentImpl.FiltersNestedImpl(-1, item);
  }
  public TriggerSpecFluentImpl.FiltersNested<A> setNewFilterLike(int index,SubscriptionsAPIFilter item) {
    return new TriggerSpecFluentImpl.FiltersNestedImpl(index, item);
  }
  public TriggerSpecFluentImpl.FiltersNested<A> editFilter(int index) {
    if (filters.size() <= index) throw new RuntimeException("Can't edit filters. Index exceeds size.");
    return setNewFilterLike(index, buildFilter(index));
  }
  public TriggerSpecFluentImpl.FiltersNested<A> editFirstFilter() {
    if (filters.size() == 0) throw new RuntimeException("Can't edit first filters. The list is empty.");
    return setNewFilterLike(0, buildFilter(0));
  }
  public TriggerSpecFluentImpl.FiltersNested<A> editLastFilter() {
    int index = filters.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last filters. The list is empty.");
    return setNewFilterLike(index, buildFilter(index));
  }
  public TriggerSpecFluentImpl.FiltersNested<A> editMatchingFilter(Predicate<SubscriptionsAPIFilterBuilder> predicate) {
    int index = -1;
    for (int i=0;i<filters.size();i++) { 
    if (predicate.test(filters.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching filters. No match found.");
    return setNewFilterLike(index, buildFilter(index));
  }
  
  /**
   * This method has been deprecated, please use method buildSubscriber instead.
   * @return The buildable object.
   */
  @Deprecated
  public Destination getSubscriber() {
    return this.subscriber!=null ?this.subscriber.build():null;
  }
  public Destination buildSubscriber() {
    return this.subscriber!=null ?this.subscriber.build():null;
  }
  public A withSubscriber(Destination subscriber) {
    _visitables.get("subscriber").remove(this.subscriber);
    if (subscriber!=null){ this.subscriber= new DestinationBuilder(subscriber); _visitables.get("subscriber").add(this.subscriber);} else { this.subscriber = null; _visitables.get("subscriber").remove(this.subscriber); } return (A) this;
  }
  public Boolean hasSubscriber() {
    return this.subscriber != null;
  }
  public TriggerSpecFluentImpl.SubscriberNested<A> withNewSubscriber() {
    return new TriggerSpecFluentImpl.SubscriberNestedImpl();
  }
  public TriggerSpecFluentImpl.SubscriberNested<A> withNewSubscriberLike(Destination item) {
    return new TriggerSpecFluentImpl.SubscriberNestedImpl(item);
  }
  public TriggerSpecFluentImpl.SubscriberNested<A> editSubscriber() {
    return withNewSubscriberLike(getSubscriber());
  }
  public TriggerSpecFluentImpl.SubscriberNested<A> editOrNewSubscriber() {
    return withNewSubscriberLike(getSubscriber() != null ? getSubscriber(): new DestinationBuilder().build());
  }
  public TriggerSpecFluentImpl.SubscriberNested<A> editOrNewSubscriberLike(Destination item) {
    return withNewSubscriberLike(getSubscriber() != null ? getSubscriber(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TriggerSpecFluentImpl that = (TriggerSpecFluentImpl) o;
    if (!java.util.Objects.equals(broker, that.broker)) return false;

    if (!java.util.Objects.equals(delivery, that.delivery)) return false;

    if (!java.util.Objects.equals(filter, that.filter)) return false;

    if (!java.util.Objects.equals(filters, that.filters)) return false;

    if (!java.util.Objects.equals(subscriber, that.subscriber)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(broker,  delivery,  filter,  filters,  subscriber,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (broker != null) { sb.append("broker:"); sb.append(broker + ","); }
    if (delivery != null) { sb.append("delivery:"); sb.append(delivery + ","); }
    if (filter != null) { sb.append("filter:"); sb.append(filter + ","); }
    if (filters != null) { sb.append("filters:"); sb.append(filters + ","); }
    if (subscriber != null) { sb.append("subscriber:"); sb.append(subscriber); }
    sb.append("}");
    return sb.toString();
  }
  class DeliveryNestedImpl<N> extends DeliverySpecFluentImpl<TriggerSpecFluentImpl.DeliveryNested<N>> implements TriggerSpecFluentImpl.DeliveryNested<N>,Nested<N>{
    DeliveryNestedImpl(DeliverySpec item) {
      this.builder = new DeliverySpecBuilder(this, item);
    }
    DeliveryNestedImpl() {
      this.builder = new DeliverySpecBuilder(this);
    }
    DeliverySpecBuilder builder;
    public N and() {
      return (N) TriggerSpecFluentImpl.this.withDelivery(builder.build());
    }
    public N endDelivery() {
      return and();
    }
    
  }
  class FilterNestedImpl<N> extends TriggerFilterFluentImpl<TriggerSpecFluentImpl.FilterNested<N>> implements TriggerSpecFluentImpl.FilterNested<N>,Nested<N>{
    FilterNestedImpl(TriggerFilter item) {
      this.builder = new TriggerFilterBuilder(this, item);
    }
    FilterNestedImpl() {
      this.builder = new TriggerFilterBuilder(this);
    }
    TriggerFilterBuilder builder;
    public N and() {
      return (N) TriggerSpecFluentImpl.this.withFilter(builder.build());
    }
    public N endFilter() {
      return and();
    }
    
  }
  class FiltersNestedImpl<N> extends SubscriptionsAPIFilterFluentImpl<TriggerSpecFluentImpl.FiltersNested<N>> implements TriggerSpecFluentImpl.FiltersNested<N>,Nested<N>{
    FiltersNestedImpl(int index,SubscriptionsAPIFilter item) {
      this.index = index;
      this.builder = new SubscriptionsAPIFilterBuilder(this, item);
    }
    FiltersNestedImpl() {
      this.index = -1;
      this.builder = new SubscriptionsAPIFilterBuilder(this);
    }
    SubscriptionsAPIFilterBuilder builder;
    int index;
    public N and() {
      return (N) TriggerSpecFluentImpl.this.setToFilters(index,builder.build());
    }
    public N endFilter() {
      return and();
    }
    
  }
  class SubscriberNestedImpl<N> extends DestinationFluentImpl<TriggerSpecFluentImpl.SubscriberNested<N>> implements TriggerSpecFluentImpl.SubscriberNested<N>,Nested<N>{
    SubscriberNestedImpl(Destination item) {
      this.builder = new DestinationBuilder(this, item);
    }
    SubscriberNestedImpl() {
      this.builder = new DestinationBuilder(this);
    }
    DestinationBuilder builder;
    public N and() {
      return (N) TriggerSpecFluentImpl.this.withSubscriber(builder.build());
    }
    public N endSubscriber() {
      return and();
    }
    
  }
  
}