package io.fabric8.knative.eventing.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TriggerStatusBuilder extends TriggerStatusFluentImpl<TriggerStatusBuilder> implements VisitableBuilder<TriggerStatus,TriggerStatusBuilder>{
  public TriggerStatusBuilder() {
    this(false);
  }
  public TriggerStatusBuilder(Boolean validationEnabled) {
    this(new TriggerStatus(), validationEnabled);
  }
  public TriggerStatusBuilder(TriggerStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public TriggerStatusBuilder(TriggerStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TriggerStatus(), validationEnabled);
  }
  public TriggerStatusBuilder(TriggerStatusFluent<?> fluent,TriggerStatus instance) {
    this(fluent, instance, false);
  }
  public TriggerStatusBuilder(TriggerStatusFluent<?> fluent,TriggerStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withConditions(instance.getConditions());
      fluent.withDeadLetterSinkUri(instance.getDeadLetterSinkUri());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withSubscriberUri(instance.getSubscriberUri());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TriggerStatusBuilder(TriggerStatus instance) {
    this(instance,false);
  }
  public TriggerStatusBuilder(TriggerStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAnnotations(instance.getAnnotations());
      this.withConditions(instance.getConditions());
      this.withDeadLetterSinkUri(instance.getDeadLetterSinkUri());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withSubscriberUri(instance.getSubscriberUri());
    }
    this.validationEnabled = validationEnabled; 
  }
  TriggerStatusFluent<?> fluent;
  Boolean validationEnabled;
  public TriggerStatus build() {
    TriggerStatus buildable = new TriggerStatus(fluent.getAnnotations(),fluent.getConditions(),fluent.getDeadLetterSinkUri(),fluent.getObservedGeneration(),fluent.getSubscriberUri());
    return buildable;
  }
  
}