package io.fabric8.knative.eventing.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EventTypeListBuilder extends EventTypeListFluentImpl<EventTypeListBuilder> implements VisitableBuilder<EventTypeList,EventTypeListBuilder>{
  public EventTypeListBuilder() {
    this(false);
  }
  public EventTypeListBuilder(Boolean validationEnabled) {
    this(new EventTypeList(), validationEnabled);
  }
  public EventTypeListBuilder(EventTypeListFluent<?> fluent) {
    this(fluent, false);
  }
  public EventTypeListBuilder(EventTypeListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EventTypeList(), validationEnabled);
  }
  public EventTypeListBuilder(EventTypeListFluent<?> fluent,EventTypeList instance) {
    this(fluent, instance, false);
  }
  public EventTypeListBuilder(EventTypeListFluent<?> fluent,EventTypeList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EventTypeListBuilder(EventTypeList instance) {
    this(instance,false);
  }
  public EventTypeListBuilder(EventTypeList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  EventTypeListFluent<?> fluent;
  Boolean validationEnabled;
  public EventTypeList build() {
    EventTypeList buildable = new EventTypeList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}