package io.fabric8.knative.flows.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ParallelListBuilder extends ParallelListFluentImpl<ParallelListBuilder> implements VisitableBuilder<ParallelList,ParallelListBuilder>{
  public ParallelListBuilder() {
    this(false);
  }
  public ParallelListBuilder(Boolean validationEnabled) {
    this(new ParallelList(), validationEnabled);
  }
  public ParallelListBuilder(ParallelListFluent<?> fluent) {
    this(fluent, false);
  }
  public ParallelListBuilder(ParallelListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ParallelList(), validationEnabled);
  }
  public ParallelListBuilder(ParallelListFluent<?> fluent,ParallelList instance) {
    this(fluent, instance, false);
  }
  public ParallelListBuilder(ParallelListFluent<?> fluent,ParallelList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ParallelListBuilder(ParallelList instance) {
    this(instance,false);
  }
  public ParallelListBuilder(ParallelList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  ParallelListFluent<?> fluent;
  Boolean validationEnabled;
  public ParallelList build() {
    ParallelList buildable = new ParallelList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}