package io.fabric8.knative.flows.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ParallelSpecBuilder extends ParallelSpecFluentImpl<ParallelSpecBuilder> implements VisitableBuilder<ParallelSpec,ParallelSpecBuilder>{
  public ParallelSpecBuilder() {
    this(false);
  }
  public ParallelSpecBuilder(Boolean validationEnabled) {
    this(new ParallelSpec(), validationEnabled);
  }
  public ParallelSpecBuilder(ParallelSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ParallelSpecBuilder(ParallelSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ParallelSpec(), validationEnabled);
  }
  public ParallelSpecBuilder(ParallelSpecFluent<?> fluent,ParallelSpec instance) {
    this(fluent, instance, false);
  }
  public ParallelSpecBuilder(ParallelSpecFluent<?> fluent,ParallelSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withBranches(instance.getBranches());
      fluent.withChannelTemplate(instance.getChannelTemplate());
      fluent.withReply(instance.getReply());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ParallelSpecBuilder(ParallelSpec instance) {
    this(instance,false);
  }
  public ParallelSpecBuilder(ParallelSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withBranches(instance.getBranches());
      this.withChannelTemplate(instance.getChannelTemplate());
      this.withReply(instance.getReply());
    }
    this.validationEnabled = validationEnabled; 
  }
  ParallelSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ParallelSpec build() {
    ParallelSpec buildable = new ParallelSpec(fluent.getBranches(),fluent.getChannelTemplate(),fluent.getReply());
    return buildable;
  }
  
}