package io.fabric8.knative.flows.v1;

import io.fabric8.knative.internal.pkg.apis.duck.v1.Destination;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.knative.messaging.v1.ChannelTemplateSpec;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.knative.messaging.v1.ChannelTemplateSpecBuilder;
import io.fabric8.knative.messaging.v1.ChannelTemplateSpecFluentImpl;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationFluentImpl;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ParallelSpecFluentImpl<A extends ParallelSpecFluent<A>> extends BaseFluent<A> implements ParallelSpecFluent<A>{
  public ParallelSpecFluentImpl() {
  }
  public ParallelSpecFluentImpl(ParallelSpec instance) {
    if (instance != null) {
      this.withBranches(instance.getBranches());
      this.withChannelTemplate(instance.getChannelTemplate());
      this.withReply(instance.getReply());
    }
  }
  private ArrayList<ParallelBranchBuilder> branches = new ArrayList<ParallelBranchBuilder>();
  private ChannelTemplateSpecBuilder channelTemplate;
  private DestinationBuilder reply;
  public A addToBranches(int index,ParallelBranch item) {
    if (this.branches == null) {this.branches = new ArrayList<ParallelBranchBuilder>();}
    ParallelBranchBuilder builder = new ParallelBranchBuilder(item);
    if (index < 0 || index >= branches.size()) { _visitables.get("branches").add(builder); branches.add(builder); } else { _visitables.get("branches").add(index, builder); branches.add(index, builder);}
    return (A)this;
  }
  public A setToBranches(int index,ParallelBranch item) {
    if (this.branches == null) {this.branches = new ArrayList<ParallelBranchBuilder>();}
    ParallelBranchBuilder builder = new ParallelBranchBuilder(item);
    if (index < 0 || index >= branches.size()) { _visitables.get("branches").add(builder); branches.add(builder); } else { _visitables.get("branches").set(index, builder); branches.set(index, builder);}
    return (A)this;
  }
  public A addToBranches(io.fabric8.knative.flows.v1.ParallelBranch... items) {
    if (this.branches == null) {this.branches = new ArrayList<ParallelBranchBuilder>();}
    for (ParallelBranch item : items) {ParallelBranchBuilder builder = new ParallelBranchBuilder(item);_visitables.get("branches").add(builder);this.branches.add(builder);} return (A)this;
  }
  public A addAllToBranches(Collection<ParallelBranch> items) {
    if (this.branches == null) {this.branches = new ArrayList<ParallelBranchBuilder>();}
    for (ParallelBranch item : items) {ParallelBranchBuilder builder = new ParallelBranchBuilder(item);_visitables.get("branches").add(builder);this.branches.add(builder);} return (A)this;
  }
  public A removeFromBranches(io.fabric8.knative.flows.v1.ParallelBranch... items) {
    for (ParallelBranch item : items) {ParallelBranchBuilder builder = new ParallelBranchBuilder(item);_visitables.get("branches").remove(builder);if (this.branches != null) {this.branches.remove(builder);}} return (A)this;
  }
  public A removeAllFromBranches(Collection<ParallelBranch> items) {
    for (ParallelBranch item : items) {ParallelBranchBuilder builder = new ParallelBranchBuilder(item);_visitables.get("branches").remove(builder);if (this.branches != null) {this.branches.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromBranches(Predicate<ParallelBranchBuilder> predicate) {
    if (branches == null) return (A) this;
    final Iterator<ParallelBranchBuilder> each = branches.iterator();
    final List visitables = _visitables.get("branches");
    while (each.hasNext()) {
      ParallelBranchBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildBranches instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ParallelBranch> getBranches() {
    return branches != null ? build(branches) : null;
  }
  public List<ParallelBranch> buildBranches() {
    return branches != null ? build(branches) : null;
  }
  public ParallelBranch buildBranch(int index) {
    return this.branches.get(index).build();
  }
  public ParallelBranch buildFirstBranch() {
    return this.branches.get(0).build();
  }
  public ParallelBranch buildLastBranch() {
    return this.branches.get(branches.size() - 1).build();
  }
  public ParallelBranch buildMatchingBranch(Predicate<ParallelBranchBuilder> predicate) {
    for (ParallelBranchBuilder item: branches) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingBranch(Predicate<ParallelBranchBuilder> predicate) {
    for (ParallelBranchBuilder item: branches) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withBranches(List<ParallelBranch> branches) {
    if (this.branches != null) { _visitables.get("branches").clear();}
    if (branches != null) {this.branches = new ArrayList(); for (ParallelBranch item : branches){this.addToBranches(item);}} else { this.branches = null;} return (A) this;
  }
  public A withBranches(io.fabric8.knative.flows.v1.ParallelBranch... branches) {
    if (this.branches != null) {this.branches.clear(); _visitables.remove("branches"); }
    if (branches != null) {for (ParallelBranch item :branches){ this.addToBranches(item);}} return (A) this;
  }
  public Boolean hasBranches() {
    return branches != null && !branches.isEmpty();
  }
  public ParallelSpecFluentImpl.BranchesNested<A> addNewBranch() {
    return new ParallelSpecFluentImpl.BranchesNestedImpl();
  }
  public ParallelSpecFluentImpl.BranchesNested<A> addNewBranchLike(ParallelBranch item) {
    return new ParallelSpecFluentImpl.BranchesNestedImpl(-1, item);
  }
  public ParallelSpecFluentImpl.BranchesNested<A> setNewBranchLike(int index,ParallelBranch item) {
    return new ParallelSpecFluentImpl.BranchesNestedImpl(index, item);
  }
  public ParallelSpecFluentImpl.BranchesNested<A> editBranch(int index) {
    if (branches.size() <= index) throw new RuntimeException("Can't edit branches. Index exceeds size.");
    return setNewBranchLike(index, buildBranch(index));
  }
  public ParallelSpecFluentImpl.BranchesNested<A> editFirstBranch() {
    if (branches.size() == 0) throw new RuntimeException("Can't edit first branches. The list is empty.");
    return setNewBranchLike(0, buildBranch(0));
  }
  public ParallelSpecFluentImpl.BranchesNested<A> editLastBranch() {
    int index = branches.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last branches. The list is empty.");
    return setNewBranchLike(index, buildBranch(index));
  }
  public ParallelSpecFluentImpl.BranchesNested<A> editMatchingBranch(Predicate<ParallelBranchBuilder> predicate) {
    int index = -1;
    for (int i=0;i<branches.size();i++) { 
    if (predicate.test(branches.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching branches. No match found.");
    return setNewBranchLike(index, buildBranch(index));
  }
  
  /**
   * This method has been deprecated, please use method buildChannelTemplate instead.
   * @return The buildable object.
   */
  @Deprecated
  public ChannelTemplateSpec getChannelTemplate() {
    return this.channelTemplate!=null ?this.channelTemplate.build():null;
  }
  public ChannelTemplateSpec buildChannelTemplate() {
    return this.channelTemplate!=null ?this.channelTemplate.build():null;
  }
  public A withChannelTemplate(ChannelTemplateSpec channelTemplate) {
    _visitables.get("channelTemplate").remove(this.channelTemplate);
    if (channelTemplate!=null){ this.channelTemplate= new ChannelTemplateSpecBuilder(channelTemplate); _visitables.get("channelTemplate").add(this.channelTemplate);} else { this.channelTemplate = null; _visitables.get("channelTemplate").remove(this.channelTemplate); } return (A) this;
  }
  public Boolean hasChannelTemplate() {
    return this.channelTemplate != null;
  }
  public ParallelSpecFluentImpl.ChannelTemplateNested<A> withNewChannelTemplate() {
    return new ParallelSpecFluentImpl.ChannelTemplateNestedImpl();
  }
  public ParallelSpecFluentImpl.ChannelTemplateNested<A> withNewChannelTemplateLike(ChannelTemplateSpec item) {
    return new ParallelSpecFluentImpl.ChannelTemplateNestedImpl(item);
  }
  public ParallelSpecFluentImpl.ChannelTemplateNested<A> editChannelTemplate() {
    return withNewChannelTemplateLike(getChannelTemplate());
  }
  public ParallelSpecFluentImpl.ChannelTemplateNested<A> editOrNewChannelTemplate() {
    return withNewChannelTemplateLike(getChannelTemplate() != null ? getChannelTemplate(): new ChannelTemplateSpecBuilder().build());
  }
  public ParallelSpecFluentImpl.ChannelTemplateNested<A> editOrNewChannelTemplateLike(ChannelTemplateSpec item) {
    return withNewChannelTemplateLike(getChannelTemplate() != null ? getChannelTemplate(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildReply instead.
   * @return The buildable object.
   */
  @Deprecated
  public Destination getReply() {
    return this.reply!=null ?this.reply.build():null;
  }
  public Destination buildReply() {
    return this.reply!=null ?this.reply.build():null;
  }
  public A withReply(Destination reply) {
    _visitables.get("reply").remove(this.reply);
    if (reply!=null){ this.reply= new DestinationBuilder(reply); _visitables.get("reply").add(this.reply);} else { this.reply = null; _visitables.get("reply").remove(this.reply); } return (A) this;
  }
  public Boolean hasReply() {
    return this.reply != null;
  }
  public ParallelSpecFluentImpl.ReplyNested<A> withNewReply() {
    return new ParallelSpecFluentImpl.ReplyNestedImpl();
  }
  public ParallelSpecFluentImpl.ReplyNested<A> withNewReplyLike(Destination item) {
    return new ParallelSpecFluentImpl.ReplyNestedImpl(item);
  }
  public ParallelSpecFluentImpl.ReplyNested<A> editReply() {
    return withNewReplyLike(getReply());
  }
  public ParallelSpecFluentImpl.ReplyNested<A> editOrNewReply() {
    return withNewReplyLike(getReply() != null ? getReply(): new DestinationBuilder().build());
  }
  public ParallelSpecFluentImpl.ReplyNested<A> editOrNewReplyLike(Destination item) {
    return withNewReplyLike(getReply() != null ? getReply(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ParallelSpecFluentImpl that = (ParallelSpecFluentImpl) o;
    if (!java.util.Objects.equals(branches, that.branches)) return false;

    if (!java.util.Objects.equals(channelTemplate, that.channelTemplate)) return false;

    if (!java.util.Objects.equals(reply, that.reply)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(branches,  channelTemplate,  reply,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (branches != null) { sb.append("branches:"); sb.append(branches + ","); }
    if (channelTemplate != null) { sb.append("channelTemplate:"); sb.append(channelTemplate + ","); }
    if (reply != null) { sb.append("reply:"); sb.append(reply); }
    sb.append("}");
    return sb.toString();
  }
  class BranchesNestedImpl<N> extends ParallelBranchFluentImpl<ParallelSpecFluentImpl.BranchesNested<N>> implements ParallelSpecFluentImpl.BranchesNested<N>,Nested<N>{
    BranchesNestedImpl(int index,ParallelBranch item) {
      this.index = index;
      this.builder = new ParallelBranchBuilder(this, item);
    }
    BranchesNestedImpl() {
      this.index = -1;
      this.builder = new ParallelBranchBuilder(this);
    }
    ParallelBranchBuilder builder;
    int index;
    public N and() {
      return (N) ParallelSpecFluentImpl.this.setToBranches(index,builder.build());
    }
    public N endBranch() {
      return and();
    }
    
  }
  class ChannelTemplateNestedImpl<N> extends ChannelTemplateSpecFluentImpl<ParallelSpecFluentImpl.ChannelTemplateNested<N>> implements ParallelSpecFluentImpl.ChannelTemplateNested<N>,Nested<N>{
    ChannelTemplateNestedImpl(ChannelTemplateSpec item) {
      this.builder = new ChannelTemplateSpecBuilder(this, item);
    }
    ChannelTemplateNestedImpl() {
      this.builder = new ChannelTemplateSpecBuilder(this);
    }
    ChannelTemplateSpecBuilder builder;
    public N and() {
      return (N) ParallelSpecFluentImpl.this.withChannelTemplate(builder.build());
    }
    public N endChannelTemplate() {
      return and();
    }
    
  }
  class ReplyNestedImpl<N> extends DestinationFluentImpl<ParallelSpecFluentImpl.ReplyNested<N>> implements ParallelSpecFluentImpl.ReplyNested<N>,Nested<N>{
    ReplyNestedImpl(Destination item) {
      this.builder = new DestinationBuilder(this, item);
    }
    ReplyNestedImpl() {
      this.builder = new DestinationBuilder(this);
    }
    DestinationBuilder builder;
    public N and() {
      return (N) ParallelSpecFluentImpl.this.withReply(builder.build());
    }
    public N endReply() {
      return and();
    }
    
  }
  
}