package io.fabric8.knative.flows.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ParallelStatusBuilder extends ParallelStatusFluentImpl<ParallelStatusBuilder> implements VisitableBuilder<ParallelStatus,ParallelStatusBuilder>{
  public ParallelStatusBuilder() {
    this(false);
  }
  public ParallelStatusBuilder(Boolean validationEnabled) {
    this(new ParallelStatus(), validationEnabled);
  }
  public ParallelStatusBuilder(ParallelStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ParallelStatusBuilder(ParallelStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ParallelStatus(), validationEnabled);
  }
  public ParallelStatusBuilder(ParallelStatusFluent<?> fluent,ParallelStatus instance) {
    this(fluent, instance, false);
  }
  public ParallelStatusBuilder(ParallelStatusFluent<?> fluent,ParallelStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAddress(instance.getAddress());
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withBranchStatuses(instance.getBranchStatuses());
      fluent.withConditions(instance.getConditions());
      fluent.withIngressChannelStatus(instance.getIngressChannelStatus());
      fluent.withObservedGeneration(instance.getObservedGeneration());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ParallelStatusBuilder(ParallelStatus instance) {
    this(instance,false);
  }
  public ParallelStatusBuilder(ParallelStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAddress(instance.getAddress());
      this.withAnnotations(instance.getAnnotations());
      this.withBranchStatuses(instance.getBranchStatuses());
      this.withConditions(instance.getConditions());
      this.withIngressChannelStatus(instance.getIngressChannelStatus());
      this.withObservedGeneration(instance.getObservedGeneration());
    }
    this.validationEnabled = validationEnabled; 
  }
  ParallelStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ParallelStatus build() {
    ParallelStatus buildable = new ParallelStatus(fluent.getAddress(),fluent.getAnnotations(),fluent.getBranchStatuses(),fluent.getConditions(),fluent.getIngressChannelStatus(),fluent.getObservedGeneration());
    return buildable;
  }
  
}