package io.fabric8.knative.flows.v1;

import io.fabric8.knative.internal.pkg.apis.duck.v1.Destination;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.knative.messaging.v1.ChannelTemplateSpec;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.knative.messaging.v1.ChannelTemplateSpecBuilder;
import io.fabric8.knative.messaging.v1.ChannelTemplateSpecFluentImpl;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationFluentImpl;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class SequenceSpecFluentImpl<A extends SequenceSpecFluent<A>> extends BaseFluent<A> implements SequenceSpecFluent<A>{
  public SequenceSpecFluentImpl() {
  }
  public SequenceSpecFluentImpl(SequenceSpec instance) {
    if (instance != null) {
      this.withChannelTemplate(instance.getChannelTemplate());
      this.withReply(instance.getReply());
      this.withSteps(instance.getSteps());
    }
  }
  private ChannelTemplateSpecBuilder channelTemplate;
  private DestinationBuilder reply;
  private ArrayList<SequenceStepBuilder> steps = new ArrayList<SequenceStepBuilder>();
  
  /**
   * This method has been deprecated, please use method buildChannelTemplate instead.
   * @return The buildable object.
   */
  @Deprecated
  public ChannelTemplateSpec getChannelTemplate() {
    return this.channelTemplate!=null ?this.channelTemplate.build():null;
  }
  public ChannelTemplateSpec buildChannelTemplate() {
    return this.channelTemplate!=null ?this.channelTemplate.build():null;
  }
  public A withChannelTemplate(ChannelTemplateSpec channelTemplate) {
    _visitables.get("channelTemplate").remove(this.channelTemplate);
    if (channelTemplate!=null){ this.channelTemplate= new ChannelTemplateSpecBuilder(channelTemplate); _visitables.get("channelTemplate").add(this.channelTemplate);} else { this.channelTemplate = null; _visitables.get("channelTemplate").remove(this.channelTemplate); } return (A) this;
  }
  public Boolean hasChannelTemplate() {
    return this.channelTemplate != null;
  }
  public SequenceSpecFluentImpl.ChannelTemplateNested<A> withNewChannelTemplate() {
    return new SequenceSpecFluentImpl.ChannelTemplateNestedImpl();
  }
  public SequenceSpecFluentImpl.ChannelTemplateNested<A> withNewChannelTemplateLike(ChannelTemplateSpec item) {
    return new SequenceSpecFluentImpl.ChannelTemplateNestedImpl(item);
  }
  public SequenceSpecFluentImpl.ChannelTemplateNested<A> editChannelTemplate() {
    return withNewChannelTemplateLike(getChannelTemplate());
  }
  public SequenceSpecFluentImpl.ChannelTemplateNested<A> editOrNewChannelTemplate() {
    return withNewChannelTemplateLike(getChannelTemplate() != null ? getChannelTemplate(): new ChannelTemplateSpecBuilder().build());
  }
  public SequenceSpecFluentImpl.ChannelTemplateNested<A> editOrNewChannelTemplateLike(ChannelTemplateSpec item) {
    return withNewChannelTemplateLike(getChannelTemplate() != null ? getChannelTemplate(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildReply instead.
   * @return The buildable object.
   */
  @Deprecated
  public Destination getReply() {
    return this.reply!=null ?this.reply.build():null;
  }
  public Destination buildReply() {
    return this.reply!=null ?this.reply.build():null;
  }
  public A withReply(Destination reply) {
    _visitables.get("reply").remove(this.reply);
    if (reply!=null){ this.reply= new DestinationBuilder(reply); _visitables.get("reply").add(this.reply);} else { this.reply = null; _visitables.get("reply").remove(this.reply); } return (A) this;
  }
  public Boolean hasReply() {
    return this.reply != null;
  }
  public SequenceSpecFluentImpl.ReplyNested<A> withNewReply() {
    return new SequenceSpecFluentImpl.ReplyNestedImpl();
  }
  public SequenceSpecFluentImpl.ReplyNested<A> withNewReplyLike(Destination item) {
    return new SequenceSpecFluentImpl.ReplyNestedImpl(item);
  }
  public SequenceSpecFluentImpl.ReplyNested<A> editReply() {
    return withNewReplyLike(getReply());
  }
  public SequenceSpecFluentImpl.ReplyNested<A> editOrNewReply() {
    return withNewReplyLike(getReply() != null ? getReply(): new DestinationBuilder().build());
  }
  public SequenceSpecFluentImpl.ReplyNested<A> editOrNewReplyLike(Destination item) {
    return withNewReplyLike(getReply() != null ? getReply(): item);
  }
  public A addToSteps(int index,SequenceStep item) {
    if (this.steps == null) {this.steps = new ArrayList<SequenceStepBuilder>();}
    SequenceStepBuilder builder = new SequenceStepBuilder(item);
    if (index < 0 || index >= steps.size()) { _visitables.get("steps").add(builder); steps.add(builder); } else { _visitables.get("steps").add(index, builder); steps.add(index, builder);}
    return (A)this;
  }
  public A setToSteps(int index,SequenceStep item) {
    if (this.steps == null) {this.steps = new ArrayList<SequenceStepBuilder>();}
    SequenceStepBuilder builder = new SequenceStepBuilder(item);
    if (index < 0 || index >= steps.size()) { _visitables.get("steps").add(builder); steps.add(builder); } else { _visitables.get("steps").set(index, builder); steps.set(index, builder);}
    return (A)this;
  }
  public A addToSteps(io.fabric8.knative.flows.v1.SequenceStep... items) {
    if (this.steps == null) {this.steps = new ArrayList<SequenceStepBuilder>();}
    for (SequenceStep item : items) {SequenceStepBuilder builder = new SequenceStepBuilder(item);_visitables.get("steps").add(builder);this.steps.add(builder);} return (A)this;
  }
  public A addAllToSteps(Collection<SequenceStep> items) {
    if (this.steps == null) {this.steps = new ArrayList<SequenceStepBuilder>();}
    for (SequenceStep item : items) {SequenceStepBuilder builder = new SequenceStepBuilder(item);_visitables.get("steps").add(builder);this.steps.add(builder);} return (A)this;
  }
  public A removeFromSteps(io.fabric8.knative.flows.v1.SequenceStep... items) {
    for (SequenceStep item : items) {SequenceStepBuilder builder = new SequenceStepBuilder(item);_visitables.get("steps").remove(builder);if (this.steps != null) {this.steps.remove(builder);}} return (A)this;
  }
  public A removeAllFromSteps(Collection<SequenceStep> items) {
    for (SequenceStep item : items) {SequenceStepBuilder builder = new SequenceStepBuilder(item);_visitables.get("steps").remove(builder);if (this.steps != null) {this.steps.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromSteps(Predicate<SequenceStepBuilder> predicate) {
    if (steps == null) return (A) this;
    final Iterator<SequenceStepBuilder> each = steps.iterator();
    final List visitables = _visitables.get("steps");
    while (each.hasNext()) {
      SequenceStepBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildSteps instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<SequenceStep> getSteps() {
    return steps != null ? build(steps) : null;
  }
  public List<SequenceStep> buildSteps() {
    return steps != null ? build(steps) : null;
  }
  public SequenceStep buildStep(int index) {
    return this.steps.get(index).build();
  }
  public SequenceStep buildFirstStep() {
    return this.steps.get(0).build();
  }
  public SequenceStep buildLastStep() {
    return this.steps.get(steps.size() - 1).build();
  }
  public SequenceStep buildMatchingStep(Predicate<SequenceStepBuilder> predicate) {
    for (SequenceStepBuilder item: steps) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingStep(Predicate<SequenceStepBuilder> predicate) {
    for (SequenceStepBuilder item: steps) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSteps(List<SequenceStep> steps) {
    if (this.steps != null) { _visitables.get("steps").clear();}
    if (steps != null) {this.steps = new ArrayList(); for (SequenceStep item : steps){this.addToSteps(item);}} else { this.steps = null;} return (A) this;
  }
  public A withSteps(io.fabric8.knative.flows.v1.SequenceStep... steps) {
    if (this.steps != null) {this.steps.clear(); _visitables.remove("steps"); }
    if (steps != null) {for (SequenceStep item :steps){ this.addToSteps(item);}} return (A) this;
  }
  public Boolean hasSteps() {
    return steps != null && !steps.isEmpty();
  }
  public SequenceSpecFluentImpl.StepsNested<A> addNewStep() {
    return new SequenceSpecFluentImpl.StepsNestedImpl();
  }
  public SequenceSpecFluentImpl.StepsNested<A> addNewStepLike(SequenceStep item) {
    return new SequenceSpecFluentImpl.StepsNestedImpl(-1, item);
  }
  public SequenceSpecFluentImpl.StepsNested<A> setNewStepLike(int index,SequenceStep item) {
    return new SequenceSpecFluentImpl.StepsNestedImpl(index, item);
  }
  public SequenceSpecFluentImpl.StepsNested<A> editStep(int index) {
    if (steps.size() <= index) throw new RuntimeException("Can't edit steps. Index exceeds size.");
    return setNewStepLike(index, buildStep(index));
  }
  public SequenceSpecFluentImpl.StepsNested<A> editFirstStep() {
    if (steps.size() == 0) throw new RuntimeException("Can't edit first steps. The list is empty.");
    return setNewStepLike(0, buildStep(0));
  }
  public SequenceSpecFluentImpl.StepsNested<A> editLastStep() {
    int index = steps.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last steps. The list is empty.");
    return setNewStepLike(index, buildStep(index));
  }
  public SequenceSpecFluentImpl.StepsNested<A> editMatchingStep(Predicate<SequenceStepBuilder> predicate) {
    int index = -1;
    for (int i=0;i<steps.size();i++) { 
    if (predicate.test(steps.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching steps. No match found.");
    return setNewStepLike(index, buildStep(index));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SequenceSpecFluentImpl that = (SequenceSpecFluentImpl) o;
    if (!java.util.Objects.equals(channelTemplate, that.channelTemplate)) return false;

    if (!java.util.Objects.equals(reply, that.reply)) return false;

    if (!java.util.Objects.equals(steps, that.steps)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(channelTemplate,  reply,  steps,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (channelTemplate != null) { sb.append("channelTemplate:"); sb.append(channelTemplate + ","); }
    if (reply != null) { sb.append("reply:"); sb.append(reply + ","); }
    if (steps != null) { sb.append("steps:"); sb.append(steps); }
    sb.append("}");
    return sb.toString();
  }
  class ChannelTemplateNestedImpl<N> extends ChannelTemplateSpecFluentImpl<SequenceSpecFluentImpl.ChannelTemplateNested<N>> implements SequenceSpecFluentImpl.ChannelTemplateNested<N>,Nested<N>{
    ChannelTemplateNestedImpl(ChannelTemplateSpec item) {
      this.builder = new ChannelTemplateSpecBuilder(this, item);
    }
    ChannelTemplateNestedImpl() {
      this.builder = new ChannelTemplateSpecBuilder(this);
    }
    ChannelTemplateSpecBuilder builder;
    public N and() {
      return (N) SequenceSpecFluentImpl.this.withChannelTemplate(builder.build());
    }
    public N endChannelTemplate() {
      return and();
    }
    
  }
  class ReplyNestedImpl<N> extends DestinationFluentImpl<SequenceSpecFluentImpl.ReplyNested<N>> implements SequenceSpecFluentImpl.ReplyNested<N>,Nested<N>{
    ReplyNestedImpl(Destination item) {
      this.builder = new DestinationBuilder(this, item);
    }
    ReplyNestedImpl() {
      this.builder = new DestinationBuilder(this);
    }
    DestinationBuilder builder;
    public N and() {
      return (N) SequenceSpecFluentImpl.this.withReply(builder.build());
    }
    public N endReply() {
      return and();
    }
    
  }
  class StepsNestedImpl<N> extends SequenceStepFluentImpl<SequenceSpecFluentImpl.StepsNested<N>> implements SequenceSpecFluentImpl.StepsNested<N>,Nested<N>{
    StepsNestedImpl(int index,SequenceStep item) {
      this.index = index;
      this.builder = new SequenceStepBuilder(this, item);
    }
    StepsNestedImpl() {
      this.index = -1;
      this.builder = new SequenceStepBuilder(this);
    }
    SequenceStepBuilder builder;
    int index;
    public N and() {
      return (N) SequenceSpecFluentImpl.this.setToSteps(index,builder.build());
    }
    public N endStep() {
      return and();
    }
    
  }
  
}