package io.fabric8.knative.internal.eventing.pkg.apis.duck.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DeliverySpecBuilder extends DeliverySpecFluentImpl<DeliverySpecBuilder> implements VisitableBuilder<DeliverySpec,DeliverySpecBuilder>{
  public DeliverySpecBuilder() {
    this(false);
  }
  public DeliverySpecBuilder(Boolean validationEnabled) {
    this(new DeliverySpec(), validationEnabled);
  }
  public DeliverySpecBuilder(DeliverySpecFluent<?> fluent) {
    this(fluent, false);
  }
  public DeliverySpecBuilder(DeliverySpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DeliverySpec(), validationEnabled);
  }
  public DeliverySpecBuilder(DeliverySpecFluent<?> fluent,DeliverySpec instance) {
    this(fluent, instance, false);
  }
  public DeliverySpecBuilder(DeliverySpecFluent<?> fluent,DeliverySpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withBackoffDelay(instance.getBackoffDelay());
      fluent.withBackoffPolicy(instance.getBackoffPolicy());
      fluent.withDeadLetterSink(instance.getDeadLetterSink());
      fluent.withRetry(instance.getRetry());
      fluent.withRetryAfterMax(instance.getRetryAfterMax());
      fluent.withTimeout(instance.getTimeout());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DeliverySpecBuilder(DeliverySpec instance) {
    this(instance,false);
  }
  public DeliverySpecBuilder(DeliverySpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withBackoffDelay(instance.getBackoffDelay());
      this.withBackoffPolicy(instance.getBackoffPolicy());
      this.withDeadLetterSink(instance.getDeadLetterSink());
      this.withRetry(instance.getRetry());
      this.withRetryAfterMax(instance.getRetryAfterMax());
      this.withTimeout(instance.getTimeout());
    }
    this.validationEnabled = validationEnabled; 
  }
  DeliverySpecFluent<?> fluent;
  Boolean validationEnabled;
  public DeliverySpec build() {
    DeliverySpec buildable = new DeliverySpec(fluent.getBackoffDelay(),fluent.getBackoffPolicy(),fluent.getDeadLetterSink(),fluent.getRetry(),fluent.getRetryAfterMax(),fluent.getTimeout());
    return buildable;
  }
  
}